package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.agiledataecho.service.MoreActionUserSelectService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/ai/agile/user")
public class MoreActionUserSelectInfoController {

    @Autowired
    private MoreActionUserSelectService moreActionUserSelectService;

    /**
     * 获取用户自定义筛选记录
     * @param selectInfo
     * @param user
     * @return
     */
    @PostMapping("/userDefine/getUserSelectInfo")
    public ResponseEntity<?> queryUserSelectInfo(@RequestBody SceneSelectInfo selectInfo,
                                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(moreActionUserSelectService.queryMoreActionUserSelectInfo(selectInfo, user));
    }

    /**
     * 上报用户自定义筛选记录
     * @param selectInfo
     * @param user
     * @return
     */
    @PostMapping("/userDefine/submitUserSelectInfo")
    public ResponseEntity<?> submitUserSelectInfo(@RequestBody SceneSelectInfo selectInfo,
                                                     @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(moreActionUserSelectService.submitMoreActionUserSelectInfo(selectInfo, user));
    }

    /**
     * 删除用户自定义筛选记录
     * @param selectInfo
     * @param user
     * @return
     */
    @PostMapping("/userDefine/deleteUserSelectInfo")
    public ResponseEntity<?> deleteUserSelectInfo(@RequestBody SceneSelectInfo selectInfo,
                                                  @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(moreActionUserSelectService.deleteMoreActionUserSelectInfo(selectInfo, user));
    }

}
