package com.digiwin.athena.agiledataecho.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.agiledataecho.domain.EchoCharging;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 敏数Lite计费数据处理
 */
@Component
public interface EchoChargingMapper extends BaseMapper<EchoCharging> {

    /**
     * 扣减体验次数
     * @param tenantId
     * @param userId
     * @param chargingType
     * @return
     */
    int updateChargingRemain(@Param("tenantId") String tenantId, @Param("userId") String userId,@Param("chargingType") String chargingType,@Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 还原体验次数
     * @param tenantId
     * @param userId
     * @param chargingRemain
     * @param chargingType
     * @param modifyDate
     * @return
     */
    int reductionChargingRemain(@Param("tenantId") String tenantId, @Param("userId") String userId
            ,@Param("chargingRemain") Integer chargingRemain,@Param("chargingType") String chargingType,@Param("modifyDate") LocalDateTime modifyDate);

}
