package com.digiwin.athena.agiledataecho.domain;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReplyInviteResultDTO {
    private Integer code;
    private String message;
    private Boolean success;

    private InviteData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class InviteData{
        /**
         *
         * 21021;
         * 21022;
         * 21023；
         * 如果已經完成註冊；尚未加入租戶，则code为空
         */
        private String code;

        /**
         * 提出邀請中;
         * 已完成注册申请;
         * 授权已满，失败；
         * 如果已經完成註冊,尚未加入租戶，则message为空
         */
        private String message;
    }
}
