package com.digiwin.athena.agiledataecho.proxy.gmc.service.impl;


import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcResponse;
import com.digiwin.athena.agiledataecho.proxy.gmc.service.GmcService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * GMC服务实现
 *
 * @author yanfeng
 * @date 2024/7/23
 */
@Slf4j
@Service
public class GmcServiceImpl implements GmcService {

    @Autowired
    EchoEnvProperties echoEnvProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${appToken:}")
    private String appToken;

    @Override
    public List<GmcBulletinResultDTO> queryBulletinList(String token, String tenantId, List<String> codes, Integer pageNum, Integer pageSize) {
        String url = echoEnvProperties.getGmcUrl() + "/api/gmc/v2/release/query";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);

        // 构建请求体
        Map<String, Object> param = new HashMap<>();
        param.put("codes", codes);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("elaborate", true);

        HttpEntity httpEntity = new HttpEntity(param, headers);
        try {
            ResponseEntity<GmcResponse<List<GmcBulletinResultDTO>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<GmcResponse<List<GmcBulletinResultDTO>>>() {
            });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getData();
            }
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n, 请求tenantId:{}\n, 报错信息：{} ", ErrorCodeEnum.GMC_QUERY_ANNOUNCEMENT_LIST_FAIL.getErrCode(),
                    url, token, tenantId, e.getMessage());
            throw ExceptionUtil.wrap(ErrorCodeEnum.GMC_QUERY_ANNOUNCEMENT_LIST_FAIL.getErrCode(), e);
        }
        return Collections.emptyList();
    }
}