package com.digiwin.athena.agiledataecho.proxy.knowledgemaps;


import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KMCommandIntentionsDTO;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsTenantPurchasedAgileDataApplicationModel;

import java.util.List;

/**
 * KnowledgeMapsService
 *
 * @author yanfeng
 * @date 2024/7/24
 */
public interface KnowledgeMapsService {

    /**
     * 查询租户购买的敏捷数据应用列表
     *
     * @param token
     * @param tenantId
     * @return
     */
    List<KnowledgeMapsTenantPurchasedAgileDataApplicationModel> queryTenantPurchasedAgileDataApplicationList(String token, String tenantId);

    /**
     * KM场景意图模型(开场白示例)
     *
     * @param token
     * @param tenantId
     * @param locale
     * @return List<SceneIntentionModel>
     * @author yanfeng
     */
    List<KnowledgeMapsSceneIntentionModel> querySceneIntention(String token, String tenantId, String locale);


    /**
     * KM场景意图模型
     * @param token token
     * @param userId user
     * @param tenantId tenant
     * @param locale lang
     * @return bean
     */
    List<KMCommandIntentionsDTO> queryCommandIntentions(String token, String userId, String tenantId,String locale);
}