package com.digiwin.athena.agiledataecho.proxy.knowledgemaps.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.AthenaDapApiResponse;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.KnowledgeMapsService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KMCommandIntentionsDTO;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsTenantPurchasedAgileDataApplicationModel;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.List;

/**
 * @author yanfeng
 * @date 2024/7/24
 */
@Slf4j
@Service
public class KnowledgeMapsServiceImpl implements KnowledgeMapsService {

    @Autowired
    EchoEnvProperties echoEnvProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${appToken:}")
    private String appToken;

    @Override
    public List<KnowledgeMapsTenantPurchasedAgileDataApplicationModel> queryTenantPurchasedAgileDataApplicationList(String token, String tenantId) {
        String url = echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/tenant/tenantMetricApplication";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<AthenaDapApiResponse<List<KnowledgeMapsTenantPurchasedAgileDataApplicationModel>>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<AthenaDapApiResponse<List<KnowledgeMapsTenantPurchasedAgileDataApplicationModel>>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.KM_QUERY_PURCHASED_AGILE_DATA_APPLICATION_FAIL.getErrCode(),
                    url, token, tenantId, e.getMessage());
            throw ExceptionUtil.wrap(ErrorCodeEnum.KM_QUERY_PURCHASED_AGILE_DATA_APPLICATION_FAIL.getErrCode(), e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<KnowledgeMapsSceneIntentionModel> querySceneIntention(String token, String tenantId, String locale) {
        String url = echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/querySceneIntention";
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<AthenaDapApiResponse<List<KnowledgeMapsSceneIntentionModel>>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<AthenaDapApiResponse<List<KnowledgeMapsSceneIntentionModel>>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.KM_QUERY_SCENE_INTENTION_FAIL.getErrCode(),
                    url, token, tenantId, e.getMessage());

        }
        return Collections.emptyList();
    }

    @Override
    public List<KMCommandIntentionsDTO> queryCommandIntentions(String token, String userId, String tenantId, String locale) {
        String url = echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/command/queryAllCommandIntentions?userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        headers.add(GlobalConstant.ROUTER_KEY, tenantId);
        headers.add(GlobalConstant.IAM_APP_TOKEN, appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(headers);
        try {
            ResponseEntity<AthenaDapApiResponse<List<KMCommandIntentionsDTO>>> response = restTemplate.exchange(url, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<AthenaDapApiResponse<List<KMCommandIntentionsDTO>>>() {
                    });
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return response.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("{}\n,请求url:{}\n, 请求token:{}\n,请求tenantId:{}\n,报错信息：{} ", ErrorCodeEnum.KM_QUERY_SCENE_INTENTION_FAIL.getErrCode(),
                    url, token, tenantId, e.getMessage());

        }
        return Collections.emptyList();
    }


}