package com.digiwin.athena.agiledataecho.service;

import com.digiwin.athena.agiledataecho.util.SystemLanguageUtils;

import java.util.concurrent.CompletableFuture;

/**
 * @Author: SunHong
 * @Date: 2024/8/20 19:31
 * @Description: echo 公共方法
 */
public abstract class AbsEchoService {

    /**
     * 异步翻译
     */
    public static class TranslationService {
        public CompletableFuture<String> translate(String input) {
            // 异步线程翻译繁体
            return CompletableFuture.supplyAsync(() -> SystemLanguageUtils.toTraditional(input));
        }
    }
}
