package com.digiwin.athena.agiledataecho.service;

import com.digiwin.athena.agiledataecho.dto.*;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoInfoMongoData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoSelectMultiple;
import com.digiwin.athena.agiledataecho.mongodb.domain.MetricCheckMongoData;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/22 15:47
 * @Description:
 */
public interface EchoInformationService {

    void submit(EchoInformationReqDTO echoInformationReqDTO, AuthoredUser user);

    List<EchoInformationResDTO> getExceptionInfoByMessageId(String messageId, AuthoredUser user);

    void mongoSubmit(EchoInformationReqDTO echoInformationReqDTO, AuthoredUser user);

    List<EchoInfoMongoData> getMongoDbEchoInfoByMessageId(String messageId, AuthoredUser user);

    void sendMetricCheck(Map<String, Object> request, AuthoredUser user);

    List<MetricCheckMongoData> getMongoDbMetricInfoByMessageId(String messageId, AuthoredUser user);

    List<Map<String,Object>> queryPixBackendList(EchoQueryBackIdReqDTO echoQueryBackIdReqDTO, AuthoredUser user);

    AgileDataAnalysisDTO getAgileDataAnalysis(Map<String,Object> params,AuthoredUser user,String local);


    void mongoMultipleSubmit(EchoSelectMultipleReqDTO echoSelectMultipleReqDTO, AuthoredUser user);

    List<EchoSelectMultiple> getMongoMultipleLogByMessageId(String messageId, AuthoredUser user);
}
