package com.digiwin.athena.agiledataecho.service;

import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

/**
 * 多数据流融合用户自定义筛选
 */
public interface MoreActionUserSelectService {

    /**
     * 查询多数据流用户自定义筛选
     * @param selectInfo
     * @param user
     * @return
     */
    List<Object> queryMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user);

    /**
     * 提交多数据流用户自定义筛选
     * @param selectInfo
     * @param user
     * @return
     */
    boolean submitMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user);

    /**
     * 删除多数据流用户自定义筛选
     * @param selectInfo
     * @param user
     * @return
     */
    boolean deleteMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user);


}
