package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.agiledataecho.service.MoreActionUserSelectService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class MoreActionUserSelectServiceImpl implements MoreActionUserSelectService {

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    private static final String MONGODB_COLLECTION_NAME = "agile_data_user_define";


    /**
     * 多数据流用户选择信息
     * @param selectInfo
     * @param user
     * @return
     */
    @Override
    public List<Object> queryMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("sceneCode").is(selectInfo.getSceneCode())
                .and("actionId").is(selectInfo.getActionId())
                .and("type").is(selectInfo.getType()));
        AgileDataUserDefine userDefine = mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if(userDefine != null){
            return userDefine.getUserSelectInfo();
        }
        return null;
    }

    /**
     * 多数据流用户筛选信息提交
     * @param selectInfo
     * @param user
     * @return
     */
    @Override
    public boolean submitMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        if(selectInfo == null){
            return false;
        }
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("sceneCode").is(selectInfo.getSceneCode())
                .and("actionId").is(selectInfo.getActionId())
                .and("type").is(selectInfo.getType()));
        AgileDataUserDefine agileDataUserDefine = mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if(agileDataUserDefine == null){
            AgileDataUserDefine userDefine = new AgileDataUserDefine();
            userDefine.setUserId(user.getUserId());
            userDefine.setTenantId(user.getTenantId());
            userDefine.setSceneCode(selectInfo.getSceneCode());
            userDefine.setActionId(selectInfo.getActionId());
            userDefine.setType(selectInfo.getType());
            userDefine.setUserSelectInfo(selectInfo.getSelectInfo());
            mongoAgileDataPageViewTemplate.insert(userDefine,MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("userSelectInfo",selectInfo.getSelectInfo());
            mongoAgileDataPageViewTemplate.upsert(query,update,AgileDataUserDefine.class,MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    /**
     * 删除多数据流用户筛选信息
     * @param selectInfo
     * @param user
     * @return
     */
    @Override
    public boolean deleteMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        Query query = Query.query(Criteria.where("userId").is(user.getUserId())
                .and("tenantId").is(user.getTenantId())
                .and("sceneCode").is(selectInfo.getSceneCode())
                .and("type").is(selectInfo.getType()));
        mongoAgileDataPageViewTemplate.remove(query, MONGODB_COLLECTION_NAME);
        return true;
    }
}
