package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.dto.UserDefineHabitualDTO;
import com.digiwin.athena.agiledataecho.service.UserDefineHabitualStorage;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class UserDefineHabitualStorageImpl implements UserDefineHabitualStorage {

    private static final String USER_DEFINE_HABITUAL_KEY = "HABITUAL";

    private static final String MONGODB_COLLECTION_NAME = "agile_data_user_define";

    @Autowired
    @Qualifier("mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    /**
     * 操作习惯存储
     * @param userDefineHabitualDTO
     * @param authoredUser
     */
    @Override
    public boolean saveUserHabitual(UserDefineHabitualDTO userDefineHabitualDTO, AuthoredUser authoredUser) {
        if(userDefineHabitualDTO == null){
            return false;
        }
        Query query = Query.query(Criteria.where("userId").is(authoredUser.getUserId())
                .and("tenantId").is(authoredUser.getTenantId())
                .and("type").is(USER_DEFINE_HABITUAL_KEY));
        AgileDataUserDefine agileDataUserDefine = mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if(agileDataUserDefine == null){
            AgileDataUserDefine userDefine = new AgileDataUserDefine();
            userDefine.setUserId(authoredUser.getUserId());
            userDefine.setTenantId(authoredUser.getTenantId());
            userDefine.setType(USER_DEFINE_HABITUAL_KEY);
            userDefine.setProbe(userDefineHabitualDTO.getProbe());
            mongoAgileDataPageViewTemplate.insert(userDefine,MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("probe",userDefineHabitualDTO.getProbe());
            mongoAgileDataPageViewTemplate.upsert(query,update,AgileDataUserDefine.class,MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    /**
     * 操作习惯查询
     * @param authoredUser
     * @return
     */
    @Override
    public AgileDataUserDefine getUserHabitual(AuthoredUser authoredUser) {
        Query query = Query.query(Criteria.where("userId").is(authoredUser.getUserId())
                .and("tenantId").is(authoredUser.getTenantId())
                .and("type").is(USER_DEFINE_HABITUAL_KEY));
        return  mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
    }
}
