package com.digiwin.athena.show.analyzer;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 敏捷报表解析器
 */
@Slf4j
@Service
public class AgileReportPageDefineAnalyzer {

    @Autowired
    protected MessageUtils messageUtils;

    @Autowired
    private List<AgileDataPageDefineService> pageDefines;

    private AgileDataPageDefineService getPageDefine(SnapDataDTO snapDataDTO){
        AgileDataPageDefineService agileDataPageDefineService = null;
        for(AgileDataPageDefineService pageDefine : pageDefines){
            String supportKey = "AGILEDATA_DEFINE_" + snapDataDTO.getSnapData().getQueryType();
            if(StringUtils.equals(pageDefine.supportKey(), supportKey)){
                agileDataPageDefineService = pageDefine;
                break;
            }
        }
        return agileDataPageDefineService;
    }



    public AgileReport analysis(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReport agileReport;
        try {
            //根据查询方式获取敏捷数据处理定义
            AgileDataPageDefineService agileDataPageDefineService = this.getPageDefine(snapDataDTO);
            //获取敏捷数据定义
            agileReport = Objects.requireNonNull(agileDataPageDefineService).analysis(executeContext,snapDataDTO);
        } catch (BusinessException e){
            log.error("快照ID:{},解析敏捷数据呈现异常：{},{}",snapDataDTO.getSnapData().getSnapshotId(),e.getMessage(),e.toString());
            throw e;
        } catch (Exception e){
            log.error("快照ID:{},解析敏捷数据呈现异常：{},{}",snapDataDTO.getSnapData().getSnapshotId(),e.getMessage(),e.toString());
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(),messageUtils.getMessage("P.AGILEDATAECHO.800.0004"));
        }

        if(agileReport == null || CollectionUtils.isEmpty(agileReport.getReport())){
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        return agileReport;
    }




}
