package com.digiwin.athena.show.assistant;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AgileDataConstants {

    public static final String PERFORMER = "performer";

    /**
     * 敏捷数据页面
     */
    public static final String REPORT_PAGE = "agiledata-page";

    public static class DataType {

        private DataType() {
        }

        public static final String OBJECT = "object";

        public static final String STRING = "string";

        public static final String ARRAY = "array";

        public static final String DATE = "date";

        public static final String DATETIME = "datetime";

        public static final String TIME = "time";

        public static final String NUMBER = "number";

        public static final String NUMERIC = "numeric";

        public static final String BOOLEAN = "boolean";

        /**
         * 获取初始化数据的时候（如：基础资料录入双档类型作业的新增子页签界面，新增数据时，要根据元数据定义返回初始化数据给前端）要将值初始化为null值的数据类型列表
         *
         * @return 不可修改的List集合实例
         */
        public static List<String> getToNullDataTypes() {
            return Collections.unmodifiableList(Arrays.asList(NUMBER, NUMERIC, BOOLEAN, DATE, DATETIME, TIME));
        }

    }

}
