package com.digiwin.athena.show.component.card;


import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.springframework.stereotype.Service;


/**
 * 卡片组件
 */
@Service(ComponentNameConstants.CARD)
public class CardComponentImpl extends AbstractComponentService {


    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        CardComponent cardComponent = new CardComponent();
        cardComponent.setId(metadataField.getName());
        cardComponent.setType(ComponentNameConstants.CARD);
        cardComponent.setId(metadataField.getName());
        cardComponent.setHeaderName(metadataField.getDescription());
        return cardComponent;
    }
}
