package com.digiwin.athena.show.component.grid;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

public class CharCounter {
    @Data
    public static class Result {
        /**
         * 中文字符
         */
        private int chCharacter = 0;

        /**
         * 英文字符
         */
        private int enCharacter = 0;
        /**
         * 英文大写字符
         */
        private int enUpCharacter = 0;

        /**
         * 空格
         */
        private int spaceCharacter = 0;

        /**
         * 数字
         */
        private int numberCharacter = 0;

        /**
         * 其他字符
         */
        private int otherCharacter = 0;

        public int getEnNumberSpaceCharacter() {
            return enCharacter + numberCharacter + spaceCharacter;
        }

    }

    /***
     * 统计字符串中中文，英文，数字，空格等字符个数
     * @param str 需要统计的字符串
     */
    public Result count(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        Result result = new Result();
        for (int i = 0; i < str.length(); i++) {
            char tmp = str.charAt(i);
            if (tmp >= 'A' && tmp <= 'Z') {
                result.enUpCharacter++;
            } else if (tmp >= 'a' && tmp <= 'z') {
                result.enCharacter++;
            } else if ((tmp >= '0') && (tmp <= '9')) {
                result.numberCharacter++;
            } else if (tmp == ' ') {
                result.spaceCharacter++;
            } else if (isChinese(tmp)) {
                result.chCharacter++;
            } else {
                result.otherCharacter++;
            }
        }
        return result;
    }

    /***
     * 判断字符是否为中文
     * @param ch 需要判断的字符
     * @return 中文返回true，非中文返回false
     */
    private static boolean isChinese(char ch) {
        //获取此字符的UniCodeBlock
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
        // GENERAL_PUNCTUATION 判断中文的“号
        // CJK_SYMBOLS_AND_PUNCTUATION 判断中文的。号
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return false;

    }
}
