package com.digiwin.athena.show.component.gridster;


import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 栅格控件
 */
@Service(ComponentNameConstants.GRIDSTER)
public class GridsterComponentImpl {

    public AbstractComponent initComponent(List<AbstractComponent> components, AreaGroupDTO groupDTO, ExecuteContext executeContext) {

        List<AbstractComponent> abstractComponents = Lists.newArrayList();
        List<GridGroupDTO> gridGroupDTOS = Lists.newArrayList();

        GridsterComponent gridsterComponent = new GridsterComponent();
        gridsterComponent.setId(UUID.randomUUID().toString());
        gridsterComponent.setType(ECHOConstants.ComponentType.GRIDSTER);
        gridsterComponent.setGroup(abstractComponents);
        //存在用户自定义分组，无需再使用表格分组
        if(CollectionUtils.isNotEmpty(groupDTO.getDashboard())) {
            gridsterComponent.setItems(groupDTO.getDashboard());
            //按用户自定义分组
            List<AbstractComponent> groupComponents = Lists.newArrayList();
            groupDTO.getDashboard().stream().forEach(dashboard -> {
                Optional<AbstractComponent> component =components.stream().filter(data -> Objects.equals(data.getId(),dashboard.getId())).findFirst();
                if(component.isPresent()){
                    groupComponents.add(component.get());
                }
            });
            components.removeAll(groupComponents);
            if(CollectionUtils.isNotEmpty(components)){
                groupComponents.addAll(components);
            }
            gridsterComponent.setGroup(groupComponents);
        } else {
            gridsterComponent.setItems(gridGroupDTOS);
        }
        gridsterComponent.setDataType(ECHOConstants.DataType.OBJECT);
        //标题
        Map<String,Object> agileData = executeContext.getAgileData();
        gridsterComponent.setTitle(MapUtils.getString(agileData,"title"));
        return gridsterComponent;
    }


    /**
     * 未分组控件
     * @param groupList
     * @param components
     * @return
     */
    private List<AbstractComponent> getNoGroupComponent(List<List<AbstractComponent>> groupList,List<AbstractComponent> components,List<GridGroupDTO> gridGroupDTOS){
        List<AbstractComponent> noGroupComponentList = Lists.newArrayList();
        int maxLen = 0;
        for(int i =0;i<groupList.size();i++){
            maxLen = i;
            List<AbstractComponent> componentList = groupList.get(i);
            componentList.stream().forEach(component -> {
                if(!components.contains(component)){
                    noGroupComponentList.add(component);
                }
            });
        }
        int size = noGroupComponentList.size();
        int dashboard = size / 2 < 3 ? 3 : size / 2;
        this.setDashboard(maxLen,3,dashboard,noGroupComponentList,gridGroupDTOS);
        return noGroupComponentList;
    }



    /**
     * 设置区域
     * @param index
     * @param abstractComponents
     * @param gridGroupDTOS
     */
    private void setDashboard(int index,int rows,int clos,List<AbstractComponent> abstractComponents,List<GridGroupDTO> gridGroupDTOS){
        if(CollectionUtils.isNotEmpty(abstractComponents)) {
            int preX = 0;
            for (AbstractComponent abstractComponent : abstractComponents) {
                GridGroupDTO groupDTO = new GridGroupDTO();
                groupDTO.setRows(rows);
                groupDTO.setCols(clos);
                groupDTO.setX(preX);
                groupDTO.setY(index);
                groupDTO.setId(abstractComponent.getId());
                gridGroupDTOS.add(groupDTO);
                preX = groupDTO.getCols();
            }
        }
    }


}
