package com.digiwin.athena.show.component.panel;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.springframework.stereotype.Service;

import java.util.List;

@Service(ComponentNameConstants.PANEL_COMPONENT)
public class PanelComponentImpl extends AbstractComponentService {

    private static final String COMPONENT_TYPE = "PANEL";

    public AbstractComponent initDemoComponent(String path, List<MetadataField> responseFields) {
        MetadataField metadataField = new MetadataField();
        metadataField.setFieldType("object");
        metadataField.setName(COMPONENT_TYPE);
        metadataField.setDescription("白板组件");
        metadataField.setDataType("object");
        metadataField.setArray(false);
        metadataField.setCanEdit(true);
        metadataField.setPath(path);
        responseFields.add(metadataField);
        return createComponent(metadataField, null);
    }

    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        PanelComponent panelComponent = new PanelComponent();
        panelComponent.setId(metadataField.getName());
        panelComponent.setType(COMPONENT_TYPE);
        panelComponent.setId(metadataField.getName());
        panelComponent.setHeaderName(metadataField.getDescription());

        return panelComponent;
    }
}
