package com.digiwin.athena.show.component.select;

/**
 * 责任链模式：两个入参，一个出参
 *
 */
public abstract class AbstractBiChain<T, U, R> {

    protected AbstractBiChain<T, U, R> successor;

    public AbstractBiChain<T, U, R> setSuccessor(AbstractBiChain<T, U, R> successor) {
        this.successor = successor;
        return successor;
    }

    public abstract R processRequest(T t, U u);

}
