package com.digiwin.athena.show.component.select;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * select 控件
 */
@Service(ComponentNameConstants.SELECT)
@SuppressWarnings("unchecked")
public class SelectComponentImpl extends AbstractComponentService  {

    public static final String COMPONENT_TYPE = "SELECT";

    protected static final String PARENT_COMPONENT_TYPE_TABLE = "TABLE";

    protected static final String BASE_DATA_MANAGER_TABLE = "BASE_DATA_MANAGER_TABLE";

    private static final String SELECT_OPERATION_VALUE = "value";

    private static final String SELECT_OPERATION_TITLE = "title";



    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        SelectComponent selectComponent = new SelectComponent();
        selectComponent.setId(metadataField.getName());
        selectComponent.setType(COMPONENT_TYPE);
        selectComponent.setId(metadataField.getName());
        selectComponent.setDisabled(true);
        selectComponent.setEditable(false);
        if (metadataField.isCanEdit()) {
            selectComponent.setDisabled(false);
            selectComponent.setEditable(true);
        }
        List<Map<String, Object>> options = createOptions(metadataField,buildContext);
        selectComponent.setOptions(options);
        selectComponent.setHeaderName(metadataField.getDescription());
        return selectComponent;
    }



    /**
     * 创建OPTION内容
     *
     * @param metadataField 字段元数据
     * @return
     */
    protected List<Map<String, Object>> createOptions(MetadataField metadataField,BuildContext buildContext) {
        NullTagDefinitionHandler nullTagDefinitionHandler = new NullTagDefinitionHandler();

        nullTagDefinitionHandler.setSuccessor(new TagDefinitionExtendedEditorHandler());

        return nullTagDefinitionHandler.processRequest(metadataField,buildContext);
    }


    private abstract class SelectOptionHandler
            extends AbstractBiChain<MetadataField, BuildContext, List<Map<String, Object>>> {

        public abstract List<Map<String, Object>> processRequest(MetadataField metadataField,BuildContext buildContext);

    }

    private class NullTagDefinitionHandler extends SelectOptionHandler {

        @Override
        public List<Map<String, Object>> processRequest(MetadataField metadataField,BuildContext buildContext) {
            return successor.processRequest(metadataField,buildContext);
        }
    }





    private class TagDefinitionExtendedEditorHandler extends SelectOptionHandler {

        @Override
        public List<Map<String, Object>> processRequest(MetadataField metadataField,BuildContext buildContext) {
            List<Map<String, Object>> options = new ArrayList<>();
            // 扩展信息为空 或 扩展信息不包含editor 或 editor类型错误
            if (MapUtils.isEmpty(buildContext.getOption())) {
                return successor.processRequest(metadataField, buildContext);
            }
            Map<String, Object> tagOption = buildContext.getOption();
            if (MapUtils.isNotEmpty(tagOption)) {
                tagOption.forEach((k, v) -> {
                    //language是一个特殊的key，表示多语言信息，需要过滤
                    if (!Objects.equals("language", k)) {
                        Map<String, Object> option = new HashMap<>();
                        option.put(SELECT_OPERATION_VALUE, k);
                        option.put(SELECT_OPERATION_TITLE, v);
                        options.add(option);
                    }
                });
            }
            if (options.isEmpty()) {
                return successor.processRequest(metadataField, buildContext);
            }
            return options;
        }

    }

}
