package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponent;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 区域对象
 */
@Data
public class AgileDataGridsterArea {

    /**
     * x坐标
     */
    private int x;

    /**
     * y坐标
     */
    private int y;

    /**
     * 宽度
     */
    private int cols;

    /**
     * 高度
     */
    private int rows;

    /**
     * 组件宽度占比
     */
    private int componentWidth;

    /**
     * 组件高度占比
     */
    private int componentHeight;

    /**
     * 组件
     */
    private AbstractComponent component;

    /**
     * 后续层级,用于补齐宽度
     */
    private Set<Integer> nextLevel;

    private String relationType;

    public AgileDataGridsterArea(AbstractComponent abstractComponent,String relationType){
        this.component = abstractComponent;
        this.relationType = relationType;
    }


    /**
     * 默认布局
     */
    public void setSize(){
        String type = relationType;
        if(StringUtils.isEmpty(type)){
            type = component.getType();
        }
        switch (type){
            case "LABEL":
                this.cols = 4;
                this.rows = 1;
                break;
            case "STATISTIC":
                if(component instanceof AgileDataIndexComponent) {
                    AgileDataIndexComponent indexComponent = (AgileDataIndexComponent) component;
                    int colSize = indexComponent.getGroup().size() > 6 ? 6 : indexComponent.getGroup().size();
                    this.cols = colSize  * 2;
                    this.rows = indexComponent.getGroup().size() > 6 ? 3 : 2;
                } else {
                    this.cols = 2;
                    this.rows = 2;
                }
                break;
            case "ECHARTS":
//                if(component instanceof EchartsComponent) {
//                    EchartsComponent echartsComponent = (EchartsComponent) component;
//                    String echartType = StringUtils.EMPTY;
//                    List<Map<String, Object>> series = (List<Map<String, Object>>) echartsComponent.getOption().getSeries();
//                    if(CollectionUtils.isNotEmpty(series)) {
//                        for (Map<String, Object> seriesMap : series) {
//                            echartType = MapUtils.getString(seriesMap, "type");
//                        }
//                    } else {
//                        echartType = "bar";
//                    }
//                    if (StringUtils.equals("pie", echartType)) {
//                        this.cols = 6;
//                        this.rows = 4;
//                    } else {
//                        this.cols = 6;
//                        this.rows = 4;
//                    }
//                } else {
//                    this.cols = 6;
//                    this.rows = 4;
//                }
                this.cols = 6;
                this.rows = 5;
                break;
            case "PANEL":
            case "LIST":
            case "CARD":
            case "ATHENA_TABLE":
            default:
                this.cols = 12;
                this.rows = 6;
                break;
        }
    }

    /**
     * 设置自定义布局
     * @param cols
     * @param rows
     */
    public void setSize(int cols,int rows){
        this.cols = cols;
        this.rows = rows;
    }


    /**
     * 重新设置宽高
     * @param arrangeSize
     */
    public void reSize(int arrangeSize,int prevGroupSize) {
        //指标卡不许补齐
        if(component instanceof AgileDataIndexComponent) {
            return;
        }
        if(CollectionUtils.isEmpty(nextLevel)) {
            this.cols = arrangeSize - prevGroupSize;
        }
    }

    /**
     * 重新按比例计算
     * @param arrangeSize
     * @param maxWidthSize
     */
    public void reSizeProportion(int arrangeSize,int maxWidthSize){
        //当前高度占比
        //double currentHeight = (double) this.rows / (double) this.cols;
        //当前宽度占比
        if(!StringUtils.equals("STATISTIC",component.getType())) {
            double proportion = (double) this.cols / (double) arrangeSize;
            if (proportion > 0) {
                //按比例计算占比
                this.cols = (int) (maxWidthSize * proportion);
                //等比例计算高度
                //this.rows = (int) (cols * currentHeight);
            }
        }
    }




}
