package com.digiwin.athena.show.domain.queryDefine;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataAliasGrainDTO;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@Data
public class AgileReportDTO {

    /**
     * 快照ID
     */
    private String snapshotId;

    /**
     * 用户ID
     */
    private String performerId;

    /**
     * 租户信息
     */
    private String tenantId;


    /**
     * 场景编码
     */
    private String reportCode;

    /**
     * dmcId
     */
    private String dmcId;

    /**
     * 侦测ID
     */
    private String detectionId;

    /**
     * 标题
     */
    private String title;

    /**
     * 已读
     */
    private Integer readCount = 0;

    /**
     * 场景编码
     */
    private String code;

    /**
     * 查询类型 0.图谱 1.资产中心
     */
    private String queryType;

    /**
     * 创建日期
     */
    private LocalDateTime createDate;

    /**
     * 修改日期
     */
    private LocalDateTime modifyDate;

    /**
     * 维度区间
     */
    private Map<String,Object> dimensionInterval;

    /**
     * 时间粒度
     */
    private List<AgileDataAliasGrainDTO> aliasGrain;

    /**
     * 维度个数
     */
    private Integer dimensionCnt;

    /**
     * 消息ID
     */
    private String messageId;


    /**
     * 转换结果提示
     */
    private String transTips;



}
