package com.digiwin.athena.show.manager.themeMap.domain;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 看板配置信息
 */
@Data
public class ThemeMapBoardDTO {

    /**
     * 看板ID
     */
    private String boardId;

    /**
     * 看板名称
     */
    private String boardName;

    /**
     * 是否多对话
     */
    private Boolean multiDialogue;

    /**
     * 看板数据集合
     */
    private List<DataBoardQuestion> dataBoardQuestions;

    @Data
    public static class DataBoardQuestion{

        /**
         * 问题ID
         */
        private String questionId;

        /**
         * 问题
         */
        private String question;

        /**
         * 快照ID
         */
        private String snapshotId;

        /**
         * 呈现类型
         */
        private Integer showType;

        /**
         * 解决步骤
         */
        private Map<String,Object> solutionStep;
    }

}
