package com.digiwin.athena.show.metadata;/*
 * Copyright (C), 2001-2024, 鼎捷软件股份有限公司
 * FileName: com.digiwin.athena.uibot.metadata.domain
 * Author:   杨尹(22191)
 * Date:     2024/9/27 09:18
 * Description: // 模块目的、功能描述
 * History:		// 修改记录
 * <author>		<time>		<version>		<desc>
 * 22191		2024/9/27 09:18		1.0		<描述>
 */

import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;
import com.jugg.agile.spring.boot.util.JaI18nUtil;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * @author 杨尹(22191)
 * @version v1.0
 * @since 2024/9/27 09:18
 */
public class MetadataFieldService {
    static Map<String, MetadataField> map = new ConcurrentHashMap<>();

    /**
     * @param name
     * @param langDesKey 国际化key
     * @param path
     * @param canEdit
     * @return
     */
    public static MetadataField createStringField(String name, String langDesKey, String path, boolean canEdit) {
        String key = name + JaI18nUtil.getLanguage();
        if (map.get(key) != null) {
            return map.get(key);
        }
        MetadataField simpleField = MetadataField.createSimpleField(name, langDesKey, path, path, canEdit);
        map.put(key, simpleField);
        return simpleField;
    }
}
