package com.digiwin.athena.show.service;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class AgileDataGeneralPageTemplate extends AgileReportPageTemplate {


    @Autowired
    private AgileDataBestShowRuleService agileDataBestShowRuleService;

    @Override
    public String supportKey() {
        return "AGILE_DATA_TEMPLATE_GENERA";
    }

    @Override
    protected List<AgileDataBestShowRule> getBestShowRules(ExecuteContext executeContext) {
        return agileDataBestShowRuleService.getBestShowRules(executeContext);
    }


    @Override
    protected AbstractComponent createNoneDataComponent(ThemeMapReport themeMapReport, ExecuteContext executeContext, DynamicAgileData dynamicAgileData) {
        return null;
    }
}
