package com.digiwin.athena.show.service;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.Option;

import java.util.List;
import java.util.Map;

/**
 * 敏捷规则
 */
public interface AgileReportRuleService {

    /**
     * 表格规则
     * @param pageData
     * @param agileRules
     */
    void buildTableDataRule(List<Map<String, Object>> pageData, List<AgileReportRuleDTO> agileRules);


    /**
     * 图形规则
     * @param option
     * @param themeMapReport
     */
    void buildChartDataRule(Option option, List<Map<String, Object>> pageData, ThemeMapReport themeMapReport);

    /**
     * 绑定图形规则
     * @param chartBase
     * @param themeMapReport
     */
    void buildChartDataRule(ChartBase chartBase, ThemeMapReport  themeMapReport);
}
