package com.digiwin.athena.show.service;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.dynamicLayout.BordDynamicDTO;
import com.digiwin.athena.show.domain.dynamicLayout.DynamicLayoutBoard;

import java.util.List;
import java.util.Map;

/**
 * 看板动态布局计算
 */
public interface DynamicLayoutBoardService {

    /**
     * 获取看板动态布局
     * @param areas
     * @return
     */
    List<GridGroupDTO> calcDynamicLayoutBoard(AuthoredUser user, BordDynamicDTO areas, String local);

    /**
     * 获取看板动态布局
     * @param user
     * @return
     */
    Map<String,Object> generateBoardLayout(AuthoredUser user, BoardLayoutParamsDTO boardLayoutParamsDTO, String local);

    /**
     * 存储看板布局
     * @param authoredUser
     * @param boardLayoutDTO
     * @return
     */
    Boolean saveDynamicLayoutBoard(AuthoredUser authoredUser,BoardLayoutDTO boardLayoutDTO);

    /**
     * 获取看板布局
     * @param authoredUser
     * @param boardId
     * @return
     */
    BoardLayoutMongoData getDynamicLayoutBoard(AuthoredUser authoredUser,String boardId);

}
