package com.digiwin.athena.show.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.domain.ActionParameterMapping;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 敏捷规则处理
 */
@Service
public class AgileReportRuleServiceImpl implements AgileReportRuleService {

    private static final List<String> CHART_TYPE = Lists.newArrayList("line","bar");

    /**
     * 敏捷表格规则获取
     * @param pageData
     * @param agileRules
     */
    @Override
    public void buildTableDataRule(List<Map<String, Object>> pageData, List<AgileReportRuleDTO> agileRules) {
        if(CollectionUtils.isEmpty(agileRules)){
            return;
        }
        agileRules.stream().forEach(agileRule -> pageData.stream().forEach(data -> {
            switch (agileRule.getType()){
                case "alertShow" :
                    for(AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()){
                        Object objValue = MapUtils.getObject(data,agileReportRuleInfoDTO.getApplyToField());
                        Double value;
                        if(objValue instanceof Double){
                            value = Double.valueOf(objValue.toString());
                        }else {
                            continue;
                        }
                        ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                        Double compareValue = null;
                        switch (actionParameterMapping.getType()){
                            case "row":
                                compareValue = MapUtils.getDoubleValue(data,actionParameterMapping.getValue());
                                break;
                            case "constant":
                                compareValue = Double.valueOf(actionParameterMapping.getValue());
                                break;
                            default:
                                break;
                        }
                        if(this.alertField(value,compareValue,agileReportRuleInfoDTO)){
                            data.put("alertShow",true);
                        }
                    }
                    break;
                default:
                    break;
            }
        }));
    }

    @Override
    public void buildChartDataRule(Option option, List<Map<String, Object>> pageData, ThemeMapReport themeMapReport) {
        //获取需突显数据
        List<Map<String,Object>> searsList = JsonUtils.jsonToObject(JsonUtils.objectToString(option.getSeries()),List.class);
        for(int i =0;i < searsList.size();i++) {
            Map<String,Object> sears = searsList.get(i);
            //非线图/柱图暂不考虑突显/参考线
            if(!CHART_TYPE.contains(MapUtils.getString(sears,"type"))){
                return;
            }
            //突显规则
            this.buildAlertShow(sears,pageData,themeMapReport,searsList,i);
            //参考线规则
            this.buildMarkLine(sears,themeMapReport);
        }
        option.setSeries(searsList);
    }

    @Override
    public void buildChartDataRule(ChartBase chartBase, ThemeMapReport themeMapReport) {
        //获取需突显数据
        for(ChartBaseSeries chartBarSeries : chartBase.getChartBaseSeries()) {
            //非线图/柱图暂不考虑突显/参考线
            if(!CHART_TYPE.contains(chartBarSeries.getType())){
                return;
            }
            //突显规则
            this.bindAlertShow(chartBase,chartBarSeries,themeMapReport);
            //参考线规则
            this.bindMarkLine(chartBarSeries,themeMapReport);
        }
    }

    /**
     * 绑定突显规则
     * @param chartBase
     * @param chartBarSeries
     * @param themeMapReport
     */
    private void bindAlertShow(ChartBase chartBase,ChartBaseSeries chartBarSeries,ThemeMapReport themeMapReport){
        List<AgileReportRuleDTO> agileRules = themeMapReport.getAgileRule();

        if(CollectionUtils.isEmpty(agileRules)){
            return;
        }

        List<Map<String,Object>> markPointList = Lists.newArrayList();
        for(AgileReportRuleDTO agileRule :agileRules) {
            switch (agileRule.getType()) {
                case "alertShow":
                    for (AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()) {
                        List<Value> barList = chartBarSeries.getValues().stream().filter(x -> StringUtils.equals("bar",x.getType())).collect(Collectors.toList());
                        if(CollectionUtils.isEmpty(barList)){
                            continue;
                        }
                        if(barList.size() > 2){
                            continue;
                        }

                        chartBarSeries.getValues().stream().forEach(pointValue -> {
                            List<Map<String,Object>> pointList = Lists.newArrayList();
                            for(int i = 0;i<chartBase.getDatas().size();i++) {
                                Map<String,Object> data = chartBase.getDatas().get(i);
                                Object objValue = MapUtils.getObject(data,pointValue.getName());
                                Double value;
                                if(NumberUtil.isNumber(objValue.toString())){
                                    value = Double.valueOf(objValue.toString());
                                }else {
                                    continue;
                                }
                                ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                                Double compareValue = null;
                                switch (actionParameterMapping.getType()) {
                                    case "row":
                                        compareValue = MapUtils.getDoubleValue(data, actionParameterMapping.getValue());
                                        break;
                                    case "constant":
                                        compareValue = Double.valueOf(actionParameterMapping.getValue());
                                        break;
                                    default:
                                        break;
                                }
                                //取较大值
                                if (this.alertField(value, compareValue, agileReportRuleInfoDTO)) {
                                    Map<String,Object> markMap = Maps.newHashMap();
                                    markMap.put("value",value);
                                    markMap.put("xAxis",i);
                                    markMap.put("yAxis",value);
                                    markPointList.add(markMap);
                                }
                            }
                            ChartPointInfo chartPointInfo = new ChartPointInfo();
                            chartPointInfo.setPointValues(pointList);
                            ChartFormat chartFormat = new ChartFormat();
                            chartFormat.setPercent(pointValue.getPercent());
                            chartFormat.setDecimal(pointValue.getDecimal());
                            chartPointInfo.setFormat(chartFormat);
                            pointValue.setPointName(chartPointInfo);
                        });

                    }
                    break;
                case "growthRate":
                    List<Value> barList = chartBarSeries.getValues().stream().filter(x -> StringUtils.equals("bar",x.getType())).collect(Collectors.toList());
                    if(CollectionUtils.isEmpty(barList)){
                        continue;
                    }
                    if(barList.size() > 2){
                        continue;
                    }
                    //第2根柱子设置差异量
                    Value value = barList.get(1);
                    ChartPointInfo chartPointInfo = new ChartPointInfo();
                    List<Map<String,Object>> pointList = Lists.newArrayList();
                    ChartFormat pointFormat = new ChartFormat();
                    Map<String, MetadataField> fieldMap = ConvertGetAgileData.getAgileData(themeMapReport.getActionId(),themeMapReport.getApiMetadata());
                    agileRule.getRules().stream().forEach(growRule -> {
                        //获取差异量元数据
                        MetadataField growMetadataField = fieldMap.get(growRule.getApplyToField());
                        pointFormat.setDecimal(growMetadataField.getDecimal());
                        pointFormat.setPercent(growMetadataField.getPercent());
                        //格式化差异量
                        for(int i =0;i < chartBase.getDatas().size();i++){
                            Map<String,Object> data = chartBase.getDatas().get(i);
                            Map<String,Object> pointMap = Maps.newHashMap();
                            //此处获取差异量字段的元数据
                            if(growMetadataField != null && StringUtils.isNotEmpty(growMetadataField.getPercent())) {
                                //差异量字段
                                Object pointObj = MapUtils.getObject(data,growRule.getApplyToField());
                                if(pointObj instanceof Number) {
                                    BigDecimal pointBigDecimal = new BigDecimal(String.valueOf(pointObj));
                                    int scaleNum = growMetadataField.getDecimal() == null ? 3 : growMetadataField.getDecimal();
                                    Double formatValue = null;
                                    if(StringUtils.isNotEmpty(growMetadataField.getDecimalRule())){
                                        switch (growMetadataField.getDecimalRule()){
                                            case "up":
                                                formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_UP).doubleValue();
                                                break;
                                            case "down":
                                                formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_DOWN).doubleValue();
                                                break;
                                            case "round":
                                                formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_HALF_UP).doubleValue();
                                                break;
                                            case "absUp":
                                                pointBigDecimal = pointBigDecimal.abs();
                                                formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_UP).doubleValue();
                                                break;
                                            case "absDown":
                                                pointBigDecimal = pointBigDecimal.abs();
                                                formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_DOWN).doubleValue();
                                                break;
                                            default:
                                                break;
                                        }
                                    } else {
                                        formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_HALF_UP).doubleValue();
                                    }

                                    pointMap.put("value",formatValue);
                                    pointMap.put("xAxis",i);
                                    pointMap.put("yAxis",MapUtils.getObject(data,value.getName()));
                                    pointList.add(pointMap);
                                }
                            }
                        }
                    });
                    chartPointInfo.setFormat(pointFormat);
                    chartPointInfo.setPointValues(pointList);
                    value.setPointName(chartPointInfo);
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 绑定参考线
     * @param chartBarSeries
     * @param themeMapReport
     */
    private void bindMarkLine(ChartBaseSeries chartBarSeries,ThemeMapReport themeMapReport){
        List<AgileReportRuleDTO> agileRules = themeMapReport.getAgileRule();
        if(CollectionUtils.isEmpty(agileRules)){
            return;
        }

        //取参考线规则
        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> StringUtils.equals("markLine",x.getType())).findFirst();

        if(agileReportRuleOpt.isPresent()){
            AgileReportRuleDTO agileReportRule = agileReportRuleOpt.get();

            if(CollectionUtils.isNotEmpty(agileReportRule.getRules())) {
                //按字段合并参考线规则
                Map<String, List<AgileReportRuleInfoDTO>> ruleMap = agileReportRule.getRules().stream()
                        .filter(t -> StringUtils.isNotEmpty(t.getApplyToField()))
                        .collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField));
                //字段补齐参考线属性，供SDK生成
                chartBarSeries.getValues().stream().forEach(value -> {
                    if(MapUtils.isNotEmpty(ruleMap) && ruleMap.containsKey(value.getName())){
                        //获取改字段下所有参考规则
                        List<AgileReportRuleInfoDTO> agileDataRules = ruleMap.get(value.getName());
                        //绑定参考规则
                        if(CollectionUtils.isNotEmpty(agileDataRules)) {
                            List<String> markLineList = Lists.newArrayList();
                            agileDataRules.stream().forEach(rule -> {
                                switch (rule.getType()) {
                                    case "avg":
                                        markLineList.add("average");
                                        break;
                                    case "max":
                                        markLineList.add("max");
                                        break;
                                    case "min":
                                        markLineList.add("min");
                                        break;
                                    default:
                                        break;
                                }
                            });
                            value.setMarkLine(markLineList);
                        }
                    }
                });
            }

        }
    }



    /**
     * 构建参考线
     * @param sears
     * @param themeMapReport
     */
    private void buildMarkLine(Map<String,Object> sears,ThemeMapReport themeMapReport){
        List<AgileReportRuleDTO> agileRules = themeMapReport.getAgileRule();
        if(CollectionUtils.isEmpty(agileRules)){
            return;
        }

        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> StringUtils.equals("markLine",x.getType())).findFirst();




        if(agileReportRuleOpt.isPresent()){


            Map<String,Object> markLineMap = Maps.newHashMap();
            List<Map<String,Object>> markLineList = Lists.newArrayList();
            AgileReportRuleDTO agileReportRule = agileReportRuleOpt.get();


            //暂用字段名称匹配，后期重构
            String schemaName = MapUtils.getString(sears,"name");
            List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(themeMapReport.getActionId(),themeMapReport.getApiMetadata());
            MetadataField markLineField = new MetadataField();
            for(MetadataField metadataField : metadataFields){
                if(StringUtils.equals(schemaName,metadataField.getDescription())){
                    markLineField = metadataField;
                    break;
                }
            }
            List<AgileReportRuleInfoDTO> agileDataRules = Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(agileReportRule.getRules())) {
                Map<String, List<AgileReportRuleInfoDTO>> ruleMap = agileReportRule.getRules().stream()
                        .filter(t -> StringUtils.isNotEmpty(t.getApplyToField()))
                        .collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField));
                if(MapUtils.isNotEmpty(ruleMap) && ruleMap.containsKey(markLineField.getName())){
                    agileDataRules = ruleMap.get(markLineField.getName());
                }
            }


            if(CollectionUtils.isNotEmpty(agileDataRules)) {
                agileDataRules.forEach(rule -> {
                    switch (rule.getType()) {
                        case "avg":
                            Map<String, Object> avgMap = Maps.newHashMap();
                            avgMap.put("type", "average");
                            avgMap.put("name", rule.getName());
                            markLineList.add(avgMap);
                            break;
                        case "max":
                            Map<String, Object> maxMap = Maps.newHashMap();
                            maxMap.put("type", "max");
                            maxMap.put("name", rule.getName());
                            markLineList.add(maxMap);
                            break;
                        case "min":
                            Map<String, Object> minMap = Maps.newHashMap();
                            minMap.put("type", "min");
                            minMap.put("name", rule.getName());
                            markLineList.add(minMap);
                            break;
                        default:
                            break;
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(markLineList)) {
                markLineMap.put("data", markLineList);
                //数字显示在参考线上方
                Map<String,Object> markLabelMap = Maps.newHashMap();
                markLabelMap.put("position","insideEndTop");
                markLineMap.put("label", markLabelMap);
                sears.put("markLine",markLineMap);
            }

        }
    }

    /**
     * 突显规则构建
     * @param sears
     * @param pageData
     * @param themeMapReport
     */
    private void buildAlertShow(Map<String,Object> sears,List<Map<String, Object>> pageData,
                                ThemeMapReport themeMapReport,List<Map<String,Object>> searsList,int index){
        List<AgileReportRuleDTO> agileRules = themeMapReport.getAgileRule();
        List<Map<String,Object>> markPointList = Lists.newArrayList();
        List<String> dataList = (List<String>) MapUtils.getObject(sears,"data");
        if(CollectionUtils.isNotEmpty(dataList)){
            String growthRateField = "";
            for(int i = 0;i < dataList.size();i++){
                Object objValue = dataList.get(i);
                Double value;
                if(NumberUtil.isNumber(objValue.toString())){
                    value = Double.valueOf(objValue.toString());
                }else {
                    continue;
                }

                Map<String,Object> compareMap = pageData.get(i);
                if(CollectionUtils.isEmpty(agileRules)){
                    continue;
                }
                for(AgileReportRuleDTO agileRule :agileRules) {
                    switch (agileRule.getType()) {
                        case "alertShow":
                            for (AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()) {

                                ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                                Double compareValue = null;
                                switch (actionParameterMapping.getType()) {
                                    case "row":
                                        compareValue = MapUtils.getDoubleValue(compareMap, actionParameterMapping.getValue());
                                        break;
                                    case "constant":
                                        compareValue = Double.valueOf(actionParameterMapping.getValue());
                                        break;
                                    default:
                                        break;
                                }
                                if (this.alertField(value, compareValue, agileReportRuleInfoDTO)) {
                                    Map<String,Object> markMap = Maps.newHashMap();
                                    markMap.put("value",value);
                                    markMap.put("xAxis",i);
                                    markMap.put("yAxis",value);
                                    markPointList.add(markMap);
                                }
                            }
                            break;
                        case "growthRate":
                            List<Map<String,Object>> barList = searsList.stream().filter(x -> StringUtils.equals("bar",MapUtils.getString(x,"type"))).collect(Collectors.toList());
                            if(CollectionUtils.isEmpty(barList)){
                                continue;
                            }
                            if(barList.size() > 2){
                                continue;
                            }
                            //与上下层级比较
//                            Map<String,Object> compareSears = Maps.newHashMap();
//                            if(index == 0 && barList.size() > 1){
//                                compareSears = searsList.get(1);
//                            } else {
//                                compareSears = searsList.get(0);
//                            }
//                            List<String> compareList = (List<String>) MapUtils.getObject(compareSears,"data");
//                            String growthField = "";
//                            if(!CollectionUtils.isEmpty(agileRule.getRules())){
//                                growthField = agileRule.getRules().get(0).getApplyToField();
//                                growthRateField = growthField;
//                            }
//                            if(StringUtils.isEmpty(growthField)){
//                                continue;
//                            }
//                            Double compareValue = null;
//                            if(compareList.size() >= i){
//                                Object objCompareValue = compareList.get(i);
//                                if(NumberUtil.isNumber(objCompareValue.toString())){
//                                    compareValue = Double.valueOf(objCompareValue.toString());
//                                }else {
//                                    continue;
//                                }
//                            }
//                            if(value.compareTo(compareValue) > 0){
//                                Double growthValue = MapUtils.getDoubleValue(compareMap, growthField);
//                                Map<String, Object> markMap = Maps.newHashMap();
//                                markMap.put("value", growthValue);
//                                markMap.put("xAxis", i);
//                                markMap.put("yAxis", value);
//                                markPointList.add(markMap);
//                            }
                            if(index == 1) {
                                String growthField = "";
                                if (!CollectionUtils.isEmpty(agileRule.getRules())) {
                                    growthField = agileRule.getRules().get(0).getApplyToField();
                                    growthRateField = growthField;
                                }
                                Double growthValue = MapUtils.getDoubleValue(compareMap, growthField);
                                Map<String, Object> markMap = Maps.newHashMap();
                                markMap.put("value", growthValue);
                                markMap.put("xAxis", i);
                                markMap.put("yAxis", value);
                                markPointList.add(markMap);
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
            if(CollectionUtils.isNotEmpty(markPointList)){
                Map<String,Object> markPoint = Maps.newHashMap();
                markPoint.put("data",markPointList);

                if(!StringUtils.isEmpty(growthRateField)){
                    List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(themeMapReport.getActionId(),themeMapReport.getApiMetadata());
                    MetadataField growMetadataField = new MetadataField();
                    for(MetadataField metadataField : metadataFields){
                        if(StringUtils.equals(growthRateField,metadataField.getName())){
                            growMetadataField = metadataField;
                            break;
                        }
                    }

                    Map<String,Object> formatMap = Maps.newHashMap();
                    if(growMetadataField.getPercent() != null){
                        formatMap.put("percent",growMetadataField.getPercent());
                        for(Map<String,Object> point : markPointList){
                            Object pointObj = MapUtils.getObject(point,"value");
                            if(pointObj instanceof Number) {
                                BigDecimal pointBigDecimal = new BigDecimal(String.valueOf(pointObj));
                                int scaleNum = growMetadataField.getDecimal() == null ? 3 : growMetadataField.getDecimal();
                                Double formatValue = pointBigDecimal.setScale(scaleNum,BigDecimal.ROUND_HALF_UP).doubleValue();
                                point.put("value", formatValue);
                            }
                        }
                    }
                    if(growMetadataField.getDecimal() != null){
                        formatMap.put("decimal",growMetadataField.getDecimal());
                    }
                    markPoint.put("format",formatMap);
                } else if(sears.containsKey("format")){
                    markPoint.put("format",MapUtils.getObject(sears,"format"));
                }
                sears.put("markPoint",markPoint);
            }
        }
    }

    private Boolean alertField(Double value,Double compareValue,AgileReportRuleInfoDTO agileReportRuleInfoDTO){
        Boolean isShow = false;
        //比较值
        if(!Double.isNaN(compareValue)){
            switch (agileReportRuleInfoDTO.getOperation()){
                case "gt":
                    isShow = value.compareTo(compareValue) > 0;
                    break;
                case "lt":
                    isShow = value.compareTo(compareValue) < 0;
                    break;
                case "eq":
                    isShow = value.compareTo(compareValue) == 0;
                    break;
                default:
                    break;
            }
        }
        return isShow;
    }
}
