package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.analyzer.AgileReportPageDefineAnalyzer;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
public class AgileReportServiceImpl implements AgileReportService {

    @Autowired
    private AgileReportPageDefineAnalyzer agileReportPageDefineAnalyzer;

    @Autowired
    private List<AgileReportPageTemplate> pageDefines;

    @Override
    public DynamicAgileData createAgileReportTemplateTable(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        //获取呈现定义
        AgileReport agileReport = agileReportPageDefineAnalyzer.analysis(executeContext,snapDataDTO);
        //组装呈现结构
        return Objects.requireNonNull(getPageDefine(executeContext)).createAgileReport(executeContext,agileReport);
    }


    /**
     * 根据入口查询模板
     * @param executeContext
     * @return
     */
    private AgileReportPageTemplate getPageDefine(ExecuteContext executeContext){
        Map<String,Object> agileData = executeContext.getAgileData();
        String entry = MapUtils.getString(agileData,"entry");
        if(StringUtils.equals("1",entry)){
            entry = "SCREEN";
        } else {
            entry = "GENERA";
        }
        AgileReportPageTemplate agileReportPageTemplate = null;
        for(AgileReportPageTemplate template : pageDefines){
            String supportKey = "AGILE_DATA_TEMPLATE_" + entry;
            if(StringUtils.equals(template.supportKey(), supportKey)){
                agileReportPageTemplate = template;
                break;
            }
        }
        return agileReportPageTemplate;
    }
}
