package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.ChartBuildBase;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.Option;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("chart_line")
public class ChartBuildLineImpl extends ChartBuildBase {


    /**
     * 格式化
     * @param metadataField
     * @param buildContext
     */
    @Override
    protected void transShow(MetadataField metadataField, ChartBase chartBase, Option option,BuildContext buildContext) {
        super.transShow(metadataField,chartBase,option,buildContext);
        List<Map<String,Object>> seriesList = (List<Map<String, Object>>) option.getSeries();
        seriesList.stream().forEach(series -> {
            if(series.containsKey("markLine")){
                Map<String,Object> markMap = MapUtils.getMap(series,"markLine");
                //带参考线强行加属性
                if(markMap.containsKey("data")){
                    Map<String,Object> position = Maps.newHashMap();
                    position.put("position","insideEndTop");
                    markMap.put("label",position);
                }
            }
        });
    }


}
