package com.digiwin.athena.show.template;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.assistant.EchoShowConstants;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponentImpl;
import com.digiwin.athena.show.component.grid.GridComponent;
import com.digiwin.athena.show.component.grid.GridComponentImpl;
import com.digiwin.athena.show.component.gridster.AreaGroupDTO;
import com.digiwin.athena.show.component.gridster.DashboardDTO;
import com.digiwin.athena.show.component.gridster.GridsterComponent;
import com.digiwin.athena.show.component.gridster.GridsterComponentImpl;
import com.digiwin.athena.show.component.index.AgileDataIndexComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.*;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.MobileDSLAgileComponent;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBusinessProcess;
import com.digiwin.athena.show.service.AgileDataCardInterpreter;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.digiwin.athena.show.service.ChartBuildBase;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public abstract class AgileReportPageTemplate {


    @Autowired
    private EchartsComponentImpl echartsComponent;

    @Autowired
    private AgileDataIndexComponentImpl agileDataIndexComponentImpl;

    @Autowired
    private GridComponentImpl gridComponent;

    @Autowired
    protected GridsterComponentImpl gridsterComponentImpl;

    @Autowired
    private AgileReportRuleService agileReportRuleService;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    private AgileDataBusinessProcess agileDataBusinessProcess;

    @Autowired
    private AgileDataCardInterpreter agileDataCardInterpreter;


    @Autowired
    private ThemeAgileDataService themeAgileDataService;

    private static final List<String> CHART_TYPE = Lists.newArrayList("line", "bar");


    public String supportKey() {
        return StringUtils.lowerCase(EchoShowConstants.PATTERN_REPORT_DATA);
    }

    /**
     * 构建敏捷报表
     *
     * @param executeContext
     * @param agileReport
     * @return
     */
    public DynamicAgileData createAgileReport(ExecuteContext executeContext, AgileReport agileReport) {
        try {
            //以展现形式决定区域
            DynamicAgileData dynamicAgileData = new DynamicAgileData();
            if (CollectionUtils.isEmpty(agileReport.getReport())) {
                return dynamicAgileData;
            }
            //获取组件关系
//            List<AgileDataRelationDTO> agileDataRelationDTOList = this.getAgileDataRelation(agileReport);


            //根据展现形式构建组件
            List<AbstractComponent> abstractComponents = this.createComponents(agileReport, dynamicAgileData, executeContext);


            //生成容器，讲标题绑定在数据流上
//            abstractComponents = agileDataBusinessProcess.process(agileDataRelationDTOList, executeContext, abstractComponents, agileReport);
//
//            //girdster规则
//            List<AgileDataBestShowRule> bestShowRules = getBestShowRules(executeContext);
//
//            /**
//             * 按规则对AbstractComponent进行分组
//             */
//            AreaGroupDTO groupDTO = new AreaGroupDTO();
//
//            //设置上下文
            dynamicAgileData.setExecuteContext(executeContext);
//
//
//            //获取自定义呈现规则
//            DashboardDTO dashboardDTO = null;
//            //TODO 敏数从echo获取，格式待定
////                    agileDataUserDefineService.getGridsterLayout(executeContext, abstractComponents);
//            if (dashboardDTO == null) {
//                //获取默认呈现规则
//                dashboardDTO = new DashboardDTO();
//                dashboardDTO.setItems(ConvertAgileDataRelation.gridGroupDTOS(agileDataRelationDTOList, bestShowRules, abstractComponents, executeContext));
//            }
//            groupDTO.setDashboard(dashboardDTO.getItems());
//            AbstractComponent gridsterComponent = gridsterComponentImpl.initComponent(abstractComponents, groupDTO, executeContext);
//
//            //处理栅格容器
//            this.createPageDefineTitle(gridsterComponent, executeContext, agileReport);

            //移动端加入中间态
            if (StringUtils.equals(EchoShowConstants.WEB_PLATFORM, executeContext.getClientAgent())) {
                dynamicAgileData.setLayout(Lists.newArrayList(abstractComponents));
            } else {
                this.buildMobileDSL(dynamicAgileData,abstractComponents, executeContext, agileReport);
            }
            return dynamicAgileData;
        } catch (Exception e) {
            log.error("快照ID：{},处理敏捷数据呈现异常：{},{}", executeContext.getAgileData(), e.getMessage(), e.toString());
        }
        throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), messageUtils.getMessage("P.UIBOT.800.0004"));
    }

    /**
     * 获取最佳呈现辅助规则
     * @param executeContext
     * @return
     */
    protected abstract List<AgileDataBestShowRule> getBestShowRules(ExecuteContext executeContext);



    /**
     * 构建栅格属性
     * @param component
     * @param executeContext
     * @param agileReport
     */
    protected void createPageDefineTitle(AbstractComponent component, ExecuteContext executeContext, AgileReport agileReport) {
        if (component instanceof GridsterComponent) {
            GridsterComponent gridsterComponent = (GridsterComponent) component;
            //增加标题
            if (agileReport != null) {
                agileReport.getReport().stream().forEach(report -> gridsterComponent.setTitle(report.getTitle()));
            }
            //敏数栅格默认属性
            gridsterComponent.getItems().stream().forEach(item -> {
                //增加targetId
                item.setTargetId(item.getId());
                //增加隐藏滚动条
                item.setCellOverflow("hidden");
            });
        }
    }


    /**
     * 获取action的关系，用于最佳呈现
     *
     * @param agileReport
     * @return
     */
    protected List<AgileDataRelationDTO> getAgileDataRelation(AgileReport agileReport) {
        //优先从设计器获取
        if (CollectionUtils.isNotEmpty(agileReport.getReport())) {
            Optional<ThemeMapReport> themeMapReportOptional = agileReport.getReport().stream().findFirst();
            if (themeMapReportOptional.isPresent()) {
                ThemeMapReport themeMapReport = themeMapReportOptional.get();
                if (CollectionUtils.isNotEmpty(themeMapReport.getAgileDataRelation())) {
                    return themeMapReport.getAgileDataRelation();
                }
            }
        }
        //通过actionId获取
        List<String> actionIds = agileReport.getReport().stream().map(themeMapReport -> themeMapReport.getActionId()).collect(Collectors.toList());
        List<AgileDataRelationDTO> agileDataRelationDTOList = themeAgileDataService.queryActionRelation(actionIds);
        return agileDataRelationDTOList;
    }

    /**
     * 根据展现形式构建组件
     *
     * @param agileReport
     * @param dynamicAgileData
     * @param executeContext
     * @return
     */
    protected List<AbstractComponent> createComponents(AgileReport agileReport, DynamicAgileData dynamicAgileData, ExecuteContext executeContext) {
        List<AbstractComponent> abstractComponents = Lists.newArrayList();

        for (ThemeMapReport themeMapReport : agileReport.getReport()) {

            //默认展示表格
            if (themeMapReport.getReportShow() == null) {
                themeMapReport.setReportShow(0);
            }

            //大屏无数据，转为文本呈现
            AbstractComponent noneDataComponent = createNoneDataComponent(themeMapReport, executeContext, dynamicAgileData);
            if (noneDataComponent != null) {
                abstractComponents.add(noneDataComponent);
                continue;
            }
            //非大屏无数据，转为呈现定义构建组件
            switch (themeMapReport.getReportShow()) {
                //表格
                case 0:
                    abstractComponents.addAll(this.BuildTableLayout(executeContext, themeMapReport));
                    break;
                //eCharts
                case 1:
                case 3:
                case 4:
                case 5:
                case 6:
                    //区域唯一标识
                    AbstractComponent eChartComponent = this.buildEchartsLayout(executeContext,agileReport, themeMapReport);
                    if (eChartComponent == null) {
                        break;
                    }
                    abstractComponents.add(eChartComponent);
                    break;
                //卡片
                case 7:
                    //区域唯一标识
                    AbstractComponent cardComponent = this.buildCardLayout(executeContext, themeMapReport);
                    if (cardComponent == null) {
                        break;
                    }
                    abstractComponents.add(cardComponent);
                    break;
                //指标
                case 2:
                    //区域唯一标识
                    AbstractComponent index = this.buildIndexLayout(executeContext, themeMapReport);
                    if (index == null) {
                        break;
                    }
                    abstractComponents.add(index);
                    break;
                default:
                    break;
            }
        }
        return abstractComponents;
    }

    /**
     * 构建大屏无数据呈现内容
     *
     * @param themeMapReport
     * @param executeContext
     * @return
     */
    protected abstract AbstractComponent createNoneDataComponent(ThemeMapReport themeMapReport, ExecuteContext executeContext, DynamicAgileData dynamicAgileData);



    /**
     * 移动端构建
     *
     * @param abstractComponents
     * @param executeContext
     * @param agileReport
     */
    private void buildMobileDSL(DynamicAgileData dynamicAgileData,List<AbstractComponent> abstractComponents, ExecuteContext executeContext,AgileReport agileReport) {
        MobileDSLAgileComponent mobileDSLAgileComponent = new MobileDSLAgileComponent();
        Map<String, Object> agileData = executeContext.getAgileData();
        List<MobileDSLAgileData> mobileDSLAgileDATAList = Lists.newArrayList();

        mobileDSLAgileComponent.setType(ComponentNameConstants.DSL_AGILE);
        mobileDSLAgileComponent.setData(mobileDSLAgileDATAList);
//        mobileDSLAgileComponent.setDynamicLayout(abstractComponents);
        mobileDSLAgileComponent.setGenerateTime(MapUtils.getString(agileData, "requestTime"));
        mobileDSLAgileComponent.setData(this.getMobileAgileData(abstractComponents, executeContext, agileReport));
        dynamicAgileData.setLayout(Lists.newArrayList(mobileDSLAgileComponent));
    }

    /**
     * 获取移动中间态数据
     *
     * @param abstractComponents
     * @param executeContext
     * @param agileReport
     * @return
     */
    private List<MobileDSLAgileData> getMobileAgileData(List<AbstractComponent> abstractComponents, ExecuteContext executeContext, AgileReport agileReport) {
        List<MobileDSLAgileData> datas = Lists.newArrayList();
        for (ThemeMapReport themeMapReport : agileReport.getReport()) {
            switch (themeMapReport.getReportShow()) {
                //表格处理,将web端解析好的表格组件与定义的schema相匹配，生成多个中间态结构
                case 0:
                    List<AbstractComponent> tableComponents = abstractComponents.stream().filter(component -> StringUtils.equals(ECHOConstants.ComponentType.TABLE, component.getType())
                            && StringUtils.equals(themeMapReport.getDataSource(), component.getId())).collect(Collectors.toList());
                    datas.addAll(this.buildMobileDSLTable(executeContext, themeMapReport, tableComponents, themeMapReport.getPageData()));
                    break;
                //图表处理
                case 1:
                case 3:
                case 4:
                case 5:
                case 6:
                    Optional<AbstractComponent> echartOptional = abstractComponents.stream().filter(component -> StringUtils.equals(ECHOConstants.ComponentType.ECHARTS, component.getType())
                            && StringUtils.equals(themeMapReport.getDataSource(), component.getId())).findFirst();
                    if (echartOptional.isPresent()) {
                        datas.add(this.buildMobileDSLECharts(executeContext, themeMapReport, agileReport,echartOptional.get()));
                    }
                    break;
                //指标处理
                case 2:
                    Optional<AbstractComponent> indexOptional = abstractComponents.stream().filter(component -> StringUtils.equals(ECHOConstants.ComponentType.STATISTIC, component.getType())
                            && StringUtils.equals(themeMapReport.getDataSource(), component.getId())).findFirst();
                    datas.add(this.buildMobileDSLIndex(themeMapReport, indexOptional.get()));
                    break;
                default:
                    break;
            }
        }
        return datas;
    }

    /**
     * 构建移动端中间态表格信息
     *
     * @param executeContext
     * @param themeMapReport
     * @return
     */
    private List<MobileDSLAgileData> buildMobileDSLTable(ExecuteContext executeContext, ThemeMapReport themeMapReport, List<AbstractComponent> abstractComponents, List<Map<String, Object>> pageData) {
        List<MobileDSLAgileData> mobileDSLAgileDataList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(abstractComponents)) {
            return Lists.newArrayList();
        }
        String actionId = themeMapReport.getActionId();
        if (StringUtils.isBlank(actionId)) {
            return Lists.newArrayList();
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();

        abstractComponents.stream().forEach(abstractComponent -> {
            String title = themeMapReport.getTitle();

            MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
            mobileDSLAgileData.setShowName(title);
            mobileDSLAgileData.setShowCategory(themeMapReport.getReportShow());
            mobileDSLAgileData.setBizDataId(abstractComponent.getId());
            if (CollectionUtils.isNotEmpty(apiMetadata.getResponseFields())) {
                mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
            }
            mobileDSLAgileData.setPageData(themeMapReport.getPageData());
            if (abstractComponent instanceof GridComponent) {
                MobileDSLTableRender mobileDSLTableRender = new MobileDSLTableRender();
                Map<String, MetadataField> fieldMap = ConvertGetAgileData.getFiledMap(themeMapReport.getDataSource(), apiMetadata);
                List<AbstractComponent> columns = Lists.newArrayList();
                GridComponent gridComponent = (GridComponent) abstractComponent;
                gridComponent.getColumns().stream().forEach(gridColumnDef -> {
                    MetadataField metadataField = fieldMap.get(gridColumnDef.getId());
                    AgileDataMobileGridColumnDef agileDataMobileGridColumnDef = new AgileDataMobileGridColumnDef();
                    agileDataMobileGridColumnDef.getMobilelGridColumn(metadataField, themeMapReport.getDataSource(), gridColumnDef.getWidth());
                    columns.add(agileDataMobileGridColumnDef);
                });
                mobileDSLTableRender.setColumns(columns);
                mobileDSLAgileData.setTableRenderSetting(mobileDSLTableRender);
            }
            mobileDSLAgileDataList.add(mobileDSLAgileData);
        });
        return mobileDSLAgileDataList;
    }


    /**
     * 表格区域
     *
     * @param executeContext
     * @param themeMapReport
     */
    private List<AbstractComponent> BuildTableLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty(themeMapReport.getPageData())) {
            return Lists.newArrayList();
        }
        String actionId = themeMapReport.getActionId();
        if (StringUtils.isBlank(actionId)) {
            return Lists.newArrayList();
        }

        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();

        ApiMetadataUtil.flatMetaData(apiMetadata);

        //处理特殊的元数据信息
        sinSpecialTagToMetadata(apiMetadata);

        //规则
        agileReportRuleService.buildTableDataRule(themeMapReport.getPageData(), themeMapReport.getAgileRule());


        // 创建界面
        return createTopReport(executeContext, themeMapReport);
    }

    private void sinSpecialTagToMetadata(ApiMetadata apiMetadata) {
        List<MetadataField> responseMetadataFields = apiMetadata.getResponseFields();
        signSpecialTag(responseMetadataFields);
    }

    private void signSpecialTag(List<MetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        for (MetadataField metadataField : metadataFields) {
            if ("date".equals(metadataField.getDataType())) {
                metadataField.setDataType("string");
            }
            if ("datetime".equals(metadataField.getDataType())) {
                metadataField.setDataType("string");
            }
            if (CollectionUtils.isNotEmpty(metadataField.getSubFields())) {
                signSpecialTag(metadataField.getSubFields());
            }
        }
    }

    private MobileDSLAgileData buildMobileDSLECharts(ExecuteContext executeContext, ThemeMapReport themeMapReport, AgileReport agileReport,AbstractComponent abstractComponent) {
        MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
        if (themeMapReport == null) {
            return mobileDSLAgileData;
        }
        String actionId = themeMapReport.getDataSource();
        if (StringUtils.isBlank(actionId)) {
            return mobileDSLAgileData;
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        BuildContext buildContext = this.createBuildContext(themeMapReport, agileReport, executeContext);
        mobileDSLAgileData.setShowName(themeMapReport.getECharts().getTitle());
        mobileDSLAgileData.setShowCategory(themeMapReport.getReportShow());
        mobileDSLAgileData.setBizDataId(abstractComponent.getId());
        if (CollectionUtils.isNotEmpty(apiMetadata.getResponseFields())) {
            mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
        }

        MobileDSLChartRender mobileDSLChartRender = new MobileDSLChartRender();


        ChartBuildBase chartBuildBase = SpringUtil.getBean("chart_" + themeMapReport.getECharts().getChartType(), ChartBuildBase.class);
        ChartBase chartBase = chartBuildBase.buildChartParams(buildContext);
        //无论如何分组，主类型不会存在不同，取第一条即可
        ChartBaseSeries chartBaseSeries = new ChartBaseSeries();
        if (CollectionUtils.isNotEmpty(chartBase.getChartBaseSeries())) {
            chartBaseSeries = chartBase.getChartBaseSeries().get(0);
        }
        //整体类型
        mobileDSLChartRender.setChartType(chartBaseSeries.getType());
        //目前支持单x轴
        mobileDSLChartRender.setPoints(chartBaseSeries.getPoints());

        Map<String,MetadataField> fieldMap = ConvertGetAgileData.getAgileData(themeMapReport.getDataSourceName(), themeMapReport.getApiMetadata());
        List<MobileDSLChartRender.DSLChartValue> dslChartValues = Lists.newArrayList();
        for (int i = 0; i < chartBase.getChartBaseSeries().size(); i++) {
            ChartBaseSeries dslSeries = chartBase.getChartBaseSeries().get(i);
            if (CollectionUtils.isNotEmpty(dslSeries.getValues())) {
                for (Value value : dslSeries.getValues()) {
                    MobileDSLChartRender.DSLChartValue dslChartValue = new MobileDSLChartRender.DSLChartValue();
                    //度量标题
                    dslChartValue.setTitle(value.getTitle());
                    //图例
                    dslChartValue.setName(value.getName());
                    //字段类型
                    dslChartValue.setDataType(value.getDataType());
                    //度量呈现形式
                    dslChartValue.setChartType(value.getType());
                    //解释说明
                    if (StringUtils.isNotEmpty(value.getDescription())) {
                        dslChartValue.setDescription(value.getDescription());
                    }
                    Map<String, Object> dslMap = Maps.newHashMap();
                    dslMap.put("decimal", value.getDecimal());
                    dslMap.put("percent", value.getPercent());
                    //根据映射关系，查找到对应的扩展信息
                    MetadataField field = fieldMap.get(dslChartValue.getName());
                    if(field != null) {
                        if (StringUtils.isNotEmpty(field.getBusinessType())) {
                            dslChartValue.setBusinessType(field.getBusinessType());
                        }
                        if (StringUtils.isNotEmpty(field.getDecimalRule())) {
                            dslMap.put("decimalRule", BeanUtil.beanToMap(ConvertAgileDataUtils.getDecimalRule(field.getDecimalRule())));
                        }
                        if (StringUtils.isNotEmpty(field.getUnit())) {
                            dslMap.put("unit", BeanUtil.beanToMap(ConvertAgileDataUtils.getUnitRule(field.getUnit())));
                        }
                    }
                    dslChartValue.setGroup(i);
                    dslChartValue.setFormat(dslMap);
                    dslChartValues.add(dslChartValue);
                    //非混合图且为饼图，只取第一个度量信息
                    String overAllType = themeMapReport.getECharts().getChartType();
                    if (!StringUtils.equals("mixed", overAllType) &&
                            StringUtils.equals("pie", value.getType())) {
                        break;
                    }
                }
            }
        }
        mobileDSLChartRender.setTitle(themeMapReport.getECharts().getTitle());
        mobileDSLChartRender.setValues(dslChartValues);
        //度量呈现规则
        List<MobileDSLChartMeasure> measurePresents = Lists.newArrayList();
        //突显规则
        measurePresents.addAll(getAlertShow(mobileDSLChartRender, fieldMap, themeMapReport.getAgileRule()));
        //差异规则
        measurePresents.addAll(getGrowthRate(mobileDSLChartRender, fieldMap, themeMapReport.getAgileRule()));
        mobileDSLChartRender.setMeasurePresents(measurePresents);
        //参考线
        mobileDSLChartRender.setMarkLine(getMarkLine(mobileDSLChartRender, chartBase, themeMapReport.getAgileRule(), fieldMap));

        mobileDSLAgileData.setChartRenderSetting(mobileDSLChartRender);
        mobileDSLAgileData.setPageData(themeMapReport.getPageData());
        return mobileDSLAgileData;
    }

    /**
     * 参考线
     *
     * @param mobileDSLChartRender
     * @param agileRules
     * @return
     */
    private Map<String, Object> getMarkLine(MobileDSLChartRender mobileDSLChartRender, ChartBase chartBase, List<AgileReportRuleDTO> agileRules, Map<String, MetadataField> fieldMap) {
        Map<String, Object> markMap = Maps.newHashMap();

        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return markMap;
        }

        if (CollectionUtils.isEmpty(agileRules)) {
            return markMap;
        }
        //目前只有单轴才会出现参考线
        ChartBaseSeries chartBaseSeries = new ChartBaseSeries();
        if (CollectionUtils.isNotEmpty(chartBase.getChartBaseSeries())) {
            chartBaseSeries = chartBase.getChartBaseSeries().get(0);
        }
        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> StringUtils.equals("markLine", x.getType())).findFirst();
        chartBaseSeries.getValues().stream().forEach(value -> {
            if (agileReportRuleOpt.isPresent()) {
                List<Map<String, Object>> markLineList = Lists.newArrayList();
                AgileReportRuleDTO agileReportRule = agileReportRuleOpt.get();

                //暂用字段名称匹配，后期重构
                String schemaName = value.getTitle();
                MetadataField markLineField = new MetadataField();
                for (MetadataField metadataField : fieldMap.values()) {
                    if (StringUtils.equals(schemaName, metadataField.getDescription())) {
                        markLineField = metadataField;
                        break;
                    }
                }
                List<AgileReportRuleInfoDTO> agileDataRules = null;
                if (CollectionUtils.isNotEmpty(agileReportRule.getRules())) {
                    Map<String, List<AgileReportRuleInfoDTO>> ruleMap = agileReportRule.getRules().stream()
                            .filter(t -> org.apache.commons.lang.StringUtils.isNotEmpty(t.getApplyToField()))
                            .collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField));
                    if (MapUtils.isNotEmpty(ruleMap) && ruleMap.containsKey(markLineField.getName())) {
                        agileDataRules = ruleMap.get(markLineField.getName());
                    }
                }
                if (CollectionUtils.isNotEmpty(agileDataRules)) {
                    agileDataRules.stream().forEach(rule -> {
                        switch (rule.getType()) {
                            case "avg":
                                Map<String, Object> avgMap = Maps.newHashMap();
                                avgMap.put("type", "average");
                                avgMap.put("name", rule.getName());
                                avgMap.put("applyToValueField", value.getName());
                                markLineList.add(avgMap);
                                break;
                            case "max":
                                Map<String, Object> maxMap = Maps.newHashMap();
                                maxMap.put("type", "max");
                                maxMap.put("name", rule.getName());
                                maxMap.put("applyToValueField", value.getName());
                                markLineList.add(maxMap);
                                break;
                            case "min":
                                Map<String, Object> minMap = Maps.newHashMap();
                                minMap.put("type", "min");
                                minMap.put("name", rule.getName());
                                minMap.put("applyToValueField", value.getName());
                                markLineList.add(minMap);
                                break;
                            default:
                                break;
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(markLineList)) {
                    markMap.put("data", markLineList);
                }

            }
        });


        return markMap;
    }

    /**
     * 突显规则
     *
     * @param mobileDSLChartRender
     * @param fieldMap
     * @param agileRules
     * @return
     */
    private List<MobileDSLChartMeasure> getAlertShow(MobileDSLChartRender mobileDSLChartRender, Map<String, MetadataField> fieldMap,
                                                     List<AgileReportRuleDTO> agileRules) {
        List<MobileDSLChartMeasure> measures = Lists.newArrayList();
        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return measures;
        }

        if (CollectionUtils.isEmpty(agileRules)) {
            return measures;
        }
        List<AgileReportRuleDTO> showRules = agileRules.stream().filter(x -> StringUtils.equals("alertShow", x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(showRules)) {
            showRules.stream().forEach(agileReportRule -> agileReportRule.getRules().stream().forEach(rule -> {
                MobileDSLChartAlertShow mobileDSLChartAlertShow = new MobileDSLChartAlertShow();
                mobileDSLChartAlertShow.setFormulationId("highlightShow");
                mobileDSLChartAlertShow.setParams(rule);
                MetadataField metadataField = fieldMap.get(rule.getApplyToField());
                Map<String, Object> format = Maps.newHashMap();
                buildFormat(format,metadataField);
                mobileDSLChartAlertShow.setFormat(format);
                measures.add(mobileDSLChartAlertShow);
            }));
        }
        return measures;
    }


    private List<MobileDSLChartMeasure> getGrowthRate(MobileDSLChartRender mobileDSLChartRender, Map<String, MetadataField> fieldMap,
                                                      List<AgileReportRuleDTO> agileRules) {
        List<MobileDSLChartMeasure> measures = Lists.newArrayList();
        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return measures;
        }

        if (CollectionUtils.isEmpty(agileRules)) {
            return measures;
        }
        List<AgileReportRuleDTO> showRules = agileRules.stream().filter(x -> StringUtils.equals("growthRate", x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(showRules)) {
            showRules.stream().forEach(agileReportRule -> agileReportRule.getRules().stream().forEach(rule -> {
                MobileDSLChartGrowth mobileDSLChartGrowth = new MobileDSLChartGrowth();
                mobileDSLChartGrowth.setFormulationId("growth_rate");
                MobileDSLChartGrowthField mobileDSLChartAlertShow = new MobileDSLChartGrowthField();
                mobileDSLChartAlertShow.setPreviousField(rule.getPreviousField());
                mobileDSLChartAlertShow.setNowField(rule.getNowField());
                mobileDSLChartAlertShow.setApplyToField(rule.getApplyToField());
                mobileDSLChartGrowth.setParams(mobileDSLChartAlertShow);
                MetadataField metadataField = fieldMap.get(rule.getApplyToField());

                Map<String, Object> format = Maps.newHashMap();
                buildFormat(format,metadataField);
                mobileDSLChartGrowth.setFormat(format);
                measures.add(mobileDSLChartGrowth);
            }));
        }
        return measures;
    }

    private void buildFormat(Map<String, Object> format,MetadataField metadataField){
        if (metadataField != null) {
            format.put("decimal", metadataField.getDecimal());
            format.put("percent", metadataField.getPercent());
            if ((StringUtils.isNotEmpty(metadataField.getDecimalRule()))) {
                format.put("decimalRule",BeanUtil.beanToMap(ConvertAgileDataUtils.getDecimalRule(metadataField.getDecimalRule())));
            }
            if ((StringUtils.isNotEmpty(metadataField.getUnit()))) {
                format.put("unit",BeanUtil.beanToMap(ConvertAgileDataUtils.getUnitRule(metadataField.getUnit())));
            }
        }
    }

    /**
     * 敏捷指标
     *
     * @param themeMapReport
     * @param abstractComponent
     * @return
     */
    private MobileDSLAgileData buildMobileDSLIndex(ThemeMapReport themeMapReport, AbstractComponent abstractComponent) {
        MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
        mobileDSLAgileData.setShowName(themeMapReport.getTitle());
        String actionId = themeMapReport.getActionId();
        if (StringUtils.isBlank(actionId)) {
            return mobileDSLAgileData;
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        mobileDSLAgileData.setShowCategory(themeMapReport.getReportShow());
        //web端分为多个组件，共用同一个schema
        mobileDSLAgileData.setBizDataId(abstractComponent.getId());
        if (CollectionUtils.isNotEmpty(apiMetadata.getResponseFields())) {
            mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
        }
        List<Map<String, Object>> pageDataList = themeMapReport.getPageData();
        mobileDSLAgileData.setPageData(pageDataList);
        MobileDSLIndexRender mobileDSLIndexRender = new MobileDSLIndexRender();
        mobileDSLIndexRender.setIndexTitle(themeMapReport.getTitle());
        List<MobileDSLIndexRender.MobileDSLIndex> indexList = Lists.newArrayList();
        Map<String, MetadataField> filedMap = ConvertGetAgileData.getAgileData(themeMapReport.getDataSource(),apiMetadata);
        for (AgileReportIndex.AgileDataDefineIndex index : themeMapReport.getAgileReportIndex().getIndexes()) {
            MobileDSLIndexRender.MobileDSLIndex mobileDSLIndex = new MobileDSLIndexRender.MobileDSLIndex();
            MetadataField metadataField = filedMap.get(index.getTitle().getApplyToField());
            mobileDSLIndex.setTitle(metadataField.getDescription());
            mobileDSLIndex.setDecimal(metadataField.getDecimal());
            mobileDSLIndex.setPercent(metadataField.getPercent());

            Map<String, Object> pageMap;
            if (CollectionUtils.isNotEmpty(pageDataList)) {
                pageMap = pageDataList.get(0);
                mobileDSLIndex.setValue(MapUtils.getString(pageMap, index.getValue().getApplyToField()));
            }
            //根据映射关系，查找到对应的扩展信息
            if (StringUtils.isNotEmpty(metadataField.getBusinessType())) {
                mobileDSLIndex.setBusinessType(metadataField.getBusinessType());
            }
            if (StringUtils.isNotEmpty(metadataField.getExplanation())) {
                mobileDSLIndex.setDescription(messageUtils.getMessage("agileData.description") +
                        metadataField.getExplanation());
            }
            if (StringUtils.isNotEmpty(metadataField.getDecimalRule())) {
                mobileDSLIndex.setDecimalRule(BeanUtil.beanToMap(ConvertAgileDataUtils.getDecimalRule(metadataField.getDecimalRule())));
            }
            if (StringUtils.isNotEmpty(metadataField.getUnit())) {
                mobileDSLIndex.setUnit(BeanUtil.beanToMap(ConvertAgileDataUtils.getUnitRule(metadataField.getUnit())));
            }
            indexList.add(mobileDSLIndex);
        }
        mobileDSLIndexRender.setIndexSetting(indexList);

        mobileDSLAgileData.setMobileDSLIndexRender(mobileDSLIndexRender);
        return mobileDSLAgileData;
    }

    /**
     * 图表区域
     *
     * @param executeContext
     * @param themeMapReport
     */
    private AbstractComponent buildIndexLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        AbstractComponent index = new AbstractComponent();

        AgileReportIndex agileReportIndex = themeMapReport.getAgileReportIndex();

        BuildContext buildContext = this.createBuildContext(themeMapReport, null, executeContext);

        if (agileReportIndex != null && CollectionUtils.isNotEmpty(agileReportIndex.getIndexes())) {
           return agileDataIndexComponentImpl.createComponent(ConvertGetAgileData.getRootMetadataField(themeMapReport.getApiMetadata()), buildContext);
        }
        return index;
    }

    /**
     * 构建卡片组件
     *
     * @param executeContext
     * @param themeMapReport
     * @return
     */
    private AbstractComponent buildCardLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        BuildContext buildContext = this.createBuildContext(themeMapReport, null, executeContext);
        //封装表格
        return agileDataCardInterpreter.interpreter(themeMapReport, buildContext);
    }

    /**
     * 构建图形组件
     *
     * @param executeContext
     * @param themeMapReport
     * @return
     */
    private AbstractComponent buildEchartsLayout(ExecuteContext executeContext,AgileReport agileReport,ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty(themeMapReport.getPageData())) {
            return null;
        }
        BuildContext buildContext = this.createBuildContext(themeMapReport, agileReport,executeContext);
        //封装表格
        return echartsComponent.createComponent(null, buildContext);
    }

    private List<AbstractComponent> createTopReport(ExecuteContext executeContext,ThemeMapReport themeMapReport) {

        List<AbstractComponent> components = new ArrayList<>();
        if (themeMapReport.getApiMetadata() != null) {
            BuildContext buildContext = this.createBuildContext(themeMapReport,null,executeContext);
            themeMapReport.getApiMetadata().getResponseFields().stream().forEach(metadataField -> {
                components.add(gridComponent.createComponent(metadataField, buildContext));
            });

        }
        return components;
    }

    /**
     * 组装上下文
     *
     * @param themeMapReport
     * @return
     */
    private BuildContext createBuildContext(ThemeMapReport themeMapReport, AgileReport agileReport,ExecuteContext executeContext) {
        BuildContext buildContext = new BuildContext();
        buildContext.setExecuteContext(executeContext);
        buildContext.setThemeMapReport(themeMapReport);
        buildContext.setAgileReport(agileReport);
        return buildContext;
    }





}
