/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.app.env;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class EchoEnvProperties {
    private static final Logger log = LoggerFactory.getLogger(EchoEnvProperties.class);
    @Value(value="${ade.uri:}")
    private String adeUri;
    @Value(value="${adt.uri:}")
    private String adtUri;
    @Value(value="${semc.uri:}")
    private String semcUrl;
    @Value(value="${chatBI.uri:}")
    private String chatBIUrl;
    @Value(value="${chatBI.strategy:}")
    private String chatStrategy;
    @Value(value="${chatBI.gptModel:}")
    private String chatGptModel;
    @Value(value="${gmc.uri:}")
    private String gmcUrl;
    @Value(value="${themeMap.uri:}")
    private String knowledgeMapsUrl;
    @Value(value="${iam.uri:}")
    private String iamUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${language:}")
    private String defaultLanguage;
    private LocalDateTime currentTime;
    private ZoneId currentZoneId;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private String host;
    private String ipAddress;
    private long runtime;
    private int threadCount;
    private long pid;
    private LocalDateTime startTime;

    public void refresh() {
        this.currentTime = LocalDateTime.now();
        this.currentZoneId = ZoneId.systemDefault();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(EchoEnvProperties.byteToM((long)freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(EchoEnvProperties.byteToM((long)totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(EchoEnvProperties.byteToM((long)maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException var13) {
            log.warn("UnknownHostException", (Throwable)var13);
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = LocalDateTime.ofEpochSecond(startTime / 1000L, 0, ZoneOffset.ofHours(0));
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(EchoEnvProperties.tryGetPid());
    }

    static long byteToM(long bytes) {
        return bytes / 1024L / 1024L;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException var2) {
            return 0L;
        }
    }

    public static Logger getLog() {
        return log;
    }

    public String getAdeUri() {
        return this.adeUri;
    }

    public void setAdeUri(String adeUri) {
        this.adeUri = adeUri;
    }

    public String getAdtUri() {
        return this.adtUri;
    }

    public void setAdtUri(String adtUri) {
        this.adtUri = adtUri;
    }

    public String getSemcUrl() {
        return this.semcUrl;
    }

    public void setSemcUrl(String semcUrl) {
        this.semcUrl = semcUrl;
    }

    public String getChatBIUrl() {
        return this.chatBIUrl;
    }

    public void setChatBIUrl(String chatBIUrl) {
        this.chatBIUrl = chatBIUrl;
    }

    public String getChatStrategy() {
        return this.chatStrategy;
    }

    public void setChatStrategy(String chatStrategy) {
        this.chatStrategy = chatStrategy;
    }

    public String getChatGptModel() {
        return this.chatGptModel;
    }

    public void setChatGptModel(String chatGptModel) {
        this.chatGptModel = chatGptModel;
    }

    public String getGmcUrl() {
        return this.gmcUrl;
    }

    public void setGmcUrl(String gmcUrl) {
        this.gmcUrl = gmcUrl;
    }

    public String getKnowledgeMapsUrl() {
        return this.knowledgeMapsUrl;
    }

    public void setKnowledgeMapsUrl(String knowledgeMapsUrl) {
        this.knowledgeMapsUrl = knowledgeMapsUrl;
    }

    public String getIamUri() {
        return this.iamUri;
    }

    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }

    public String getEocUri() {
        return this.eocUri;
    }

    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public LocalDateTime getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(LocalDateTime currentTime) {
        this.currentTime = currentTime;
    }

    public ZoneId getCurrentZoneId() {
        return this.currentZoneId;
    }

    public void setCurrentZoneId(ZoneId currentZoneId) {
        this.currentZoneId = currentZoneId;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }
}

