/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoQueryBackIdReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoSelectMultipleReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/echo/exception"})
public class EchoInformationController {
    @Autowired
    private EchoInformationService echoInformationService;

    @PostMapping(value={"/submit"})
    public ResponseEntity<?> submit(@RequestBody @Validated EchoInformationReqDTO echoInformationReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.echoInformationService.submit(echoInformationReqDTO, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/queryInfo/{messageId}"})
    public ResponseEntity<?> getExceptionInfoByMessageId(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.getExceptionInfoByMessageId(messageId, user));
    }

    @PostMapping(value={"/mongo/submit"})
    public ResponseEntity<?> mongoSubmit(@RequestBody @Validated EchoInformationReqDTO echoInformationReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.echoInformationService.mongoSubmit(echoInformationReqDTO, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/mongo/get/{messageId}"})
    public ResponseEntity<?> getMongoDbEchoInfoByMessageId(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.getMongoDbEchoInfoByMessageId(messageId, user));
    }

    @PostMapping(value={"/mongo/metric/check"})
    public ResponseEntity<?> sendMetricCheck(@RequestBody @Validated Map<String, Object> request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.echoInformationService.sendMetricCheck(request, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/mongo/metric/get/{messageId}"})
    public ResponseEntity<?> getMongoDbMetricInfoByMessageId(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.getMongoDbMetricInfoByMessageId(messageId, user));
    }

    @PostMapping(value={"/queryPixBackendList"})
    public ResponseEntity<?> queryPixBackendList(@RequestBody EchoQueryBackIdReqDTO echoQueryBackIdReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.queryPixBackendList(echoQueryBackIdReqDTO, user));
    }

    @PostMapping(value={"/queryAnalysisResult"})
    public ResponseEntity<?> queryAnalysisResult(HttpServletRequest request, @RequestBody Map<String, Object> analysisData, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.getAgileDataAnalysis(analysisData, user, locale));
    }

    @PostMapping(value={"/mongo/multiple/submit"})
    public ResponseEntity<?> mongoSubmit(@RequestBody @Validated EchoSelectMultipleReqDTO echoSelectMultipleReqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.echoInformationService.mongoMultipleSubmit(echoSelectMultipleReqDTO, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/mongo/get/multiple/{messageId}"})
    public ResponseEntity<?> getMongoMultipleLogByMessageId(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoInformationService.getMongoMultipleLogByMessageId(messageId, user));
    }
}

