/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.adt.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataHooks;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenModel;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.board.SnapShotInfo;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdtServiceImpl
implements AdtService {
    private static final Logger log = LoggerFactory.getLogger(AdtServiceImpl.class);
    @Autowired
    private EchoEnvProperties echoEnvProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${appToken:}")
    private String appToken;

    public Map<String, Object> getSnapShotInfo(AuthoredUser user, String snapshotId, String locale) {
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agile/report/getData/" + snapshotId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6\u5feb\u7167\u4e0b\u8f7d\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)snapshotId);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u5feb\u7167\u4e0b\u8f7d\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_GET_FILE_URL_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public Integer getChargingUserValue(AuthoredUser user) {
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agile/config/getUserValue";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6adt \u914d\u7f6e\u8868\u7528\u6237\u5165\u53c2\uff1a{}", (Object)user);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u5feb\u7167\u4e0b\u8f7d\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (Integer)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_GET_USER_CONFIG_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return 0;
        }
    }

    public SnapDataDTO getAdtReportBySnapshotId(String reportId, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agile/report/getSnapData/" + reportId;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapDataDTO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SnapDataDTO getAdtSyncReportMoreScene(AgileDataScreenDTO agileDataScreenDTO, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agile/report/getSyncScreenSnapData";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HashMap params = Maps.newHashMap();
            params.put("sceneCode", agileDataScreenDTO.getSceneCode());
            params.put("eocMap", agileDataScreenDTO.getEocMap());
            params.put("fixedParams", agileDataScreenDTO.getFixedParams());
            params.put("requestType", agileDataScreenDTO.getRequestType());
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapDataDTO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SnapDataDTO getAdtReportMoreScene(String sceneCode, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agile/report/getScreenSnapData?sceneCode=" + sceneCode;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapDataDTO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AgileDataHooks getAgileDataHooks(String type, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/pageView/hooks/query?type=" + type;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (AgileDataHooks)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AgileDataScreenModel getAgileDataScreenModel(String modelId, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/screen/model/query?modelId=" + modelId;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (AgileDataScreenModel)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SnapDataDTO transAgileData(String transId, String snapshotId, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agileData/trans/agileData";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("transId", transId);
            paramMap.put("snapshotId", snapshotId);
            HttpEntity requestEntity = new HttpEntity((Object)paramMap, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapDataDTO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8f6c\u6362\u6570\u636e\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f:{},\u5f02\u5e38\u5806\u6808:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public SnapShotInfo getBoardData(BoardLayoutParamsDTO boardLayoutParamsDTO, String locale) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.echoEnvProperties.getAdtUri() + "/api/ai/agileData/v2/dataPanel/processMessage";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity((Object)boardLayoutParamsDTO, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (SnapShotInfo)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

