/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.gmc.service.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcResponse;
import com.digiwin.athena.agiledataecho.proxy.gmc.service.GmcService;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GmcServiceImpl
implements GmcService {
    private static final Logger log = LoggerFactory.getLogger(GmcServiceImpl.class);
    @Autowired
    EchoEnvProperties echoEnvProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${appToken:}")
    private String appToken;

    public List<GmcBulletinResultDTO> queryBulletinList(String token, String tenantId, List<String> codes, Integer pageNum, Integer pageSize) {
        String url = this.echoEnvProperties.getGmcUrl() + "/api/gmc/v2/release/query";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("codes", codes);
        param.put("pageNum", pageNum);
        param.put("pageSize", pageSize);
        param.put("elaborate", true);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((GmcResponse)response.getBody()).getData();
            }
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n, \u8bf7\u6c42tenantId:{}\n, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.GMC_QUERY_ANNOUNCEMENT_LIST_FAIL.getErrCode(), url, token, tenantId, e.getMessage()});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.GMC_QUERY_ANNOUNCEMENT_LIST_FAIL.getErrCode(), (Exception)e);
        }
        return Collections.emptyList();
    }
}

