/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.dao.EchoBulletinReadRecordMapper;
import com.digiwin.athena.agiledataecho.domain.EchoBulletinReadRecord;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinUnReadResultDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinUnReadSaveDTO;
import com.digiwin.athena.agiledataecho.proxy.gmc.service.GmcService;
import com.digiwin.athena.agiledataecho.proxy.iam.UserService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.KnowledgeMapsService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsTenantPurchasedAgileDataApplicationModel;
import com.digiwin.athena.agiledataecho.service.EchoGmcService;
import com.digiwin.athena.agiledataecho.util.SystemLanguageUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EchoGmcServiceImpl
implements EchoGmcService {
    private static final Logger log = LoggerFactory.getLogger(EchoGmcServiceImpl.class);
    @Autowired
    private GmcService gmcService;
    @Autowired
    private KnowledgeMapsService knowledgeMapsService;
    @Autowired
    private EchoBulletinReadRecordMapper bulletinReadRecordMapper;
    @Autowired
    private UserService userService;

    public List<GmcBulletinResultDTO> queryReadBulletinList(AuthoredUser user, Integer pageNum, Integer pageSize) {
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List knowledgeMapsTenantPurchasedAgileDataApplicationModels = this.knowledgeMapsService.queryTenantPurchasedAgileDataApplicationList(token, tenantId);
        if (CollectionUtils.isEmpty((Collection)knowledgeMapsTenantPurchasedAgileDataApplicationModels)) {
            log.warn("\u5df2\u8bfb\u516c\u544a:\u5f53\u524d\u7528\u6237\u672a\u8d2d\u4e70\u654f\u6377\u6570\u636e\u5e94\u7528");
            return Collections.emptyList();
        }
        List codes = knowledgeMapsTenantPurchasedAgileDataApplicationModels.stream().map(KnowledgeMapsTenantPurchasedAgileDataApplicationModel::getCode).collect(Collectors.toList());
        List bulletinList = this.queryBulletinList(user, codes, pageNum, pageSize);
        List agileDataBulletinReadRecords = this.bulletinReadRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EchoBulletinReadRecord::getTenantId, (Object)tenantId)).eq(EchoBulletinReadRecord::getUserId, (Object)userId));
        Set readSids = agileDataBulletinReadRecords.stream().map(EchoBulletinReadRecord::getSid).collect(Collectors.toSet());
        bulletinList.forEach(bulletin -> {
            if (!readSids.contains(bulletin.getSid())) {
                this.bulletinReadRecordMapper.insert((Object)new EchoBulletinReadRecord(userId, tenantId, bulletin.getSid()));
            }
            bulletin.setIsRead(Boolean.valueOf(true));
        });
        return bulletinList;
    }

    public GmcBulletinUnReadResultDTO queryUnreadBulletinList(AuthoredUser user, Integer pageNum, Integer pageSize) {
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List knowledgeMapsTenantPurchasedAgileDataApplicationModels = this.knowledgeMapsService.queryTenantPurchasedAgileDataApplicationList(token, tenantId);
        log.info("\u672a\u8bfb\u516c\u544a\u83b7\u53d6\u7684km\u8d2d\u4e70\u5e94\u7528\u5217\u8868:{}", (Object)JsonUtils.objectToString((Object)knowledgeMapsTenantPurchasedAgileDataApplicationModels));
        if (CollectionUtils.isEmpty((Collection)knowledgeMapsTenantPurchasedAgileDataApplicationModels)) {
            log.warn("\u672a\u8bfb\u516c\u544a:\u5f53\u524d\u7528\u6237\u672a\u8d2d\u4e70\u654f\u6377\u6570\u636e\u5e94\u7528");
            return null;
        }
        List codes = knowledgeMapsTenantPurchasedAgileDataApplicationModels.stream().map(KnowledgeMapsTenantPurchasedAgileDataApplicationModel::getCode).collect(Collectors.toList());
        List bulletinList = this.queryBulletinList(user, codes, pageNum, pageSize);
        GmcBulletinUnReadResultDTO gmcBulletinUnReadResultDTO = new GmcBulletinUnReadResultDTO();
        List agileDataBulletinReadRecords = this.bulletinReadRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EchoBulletinReadRecord::getTenantId, (Object)tenantId)).eq(EchoBulletinReadRecord::getUserId, (Object)userId));
        if (!CollectionUtils.isEmpty((Collection)agileDataBulletinReadRecords)) {
            bulletinList.removeIf(bulletin -> agileDataBulletinReadRecords.stream().anyMatch(record -> record.getSid().equals(bulletin.getSid())));
        }
        gmcBulletinUnReadResultDTO.setCount(Integer.valueOf(bulletinList.size()));
        gmcBulletinUnReadResultDTO.setBulletinList(bulletinList);
        return gmcBulletinUnReadResultDTO;
    }

    public Boolean saveReadBulletin(AuthoredUser user, GmcBulletinUnReadSaveDTO saveDTO) {
        try {
            this.bulletinReadRecordMapper.insertBatch(user.getUserId(), user.getTenantId(), saveDTO.getSidList());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5df2\u8bfb\u516c\u544a\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private List<GmcBulletinResultDTO> queryBulletinList(AuthoredUser user, List<String> codes, Integer pageNum, Integer pageSize) {
        String traditional;
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        List bulletins = this.gmcService.queryBulletinList(token, tenantId, codes, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)bulletins)) {
            log.warn("\u5f53\u524d\u7528\u6237\u672a\u67e5\u8be2\u5230\u516c\u544a\u5217\u8868,codes:{},user:{}", codes, (Object)JsonUtils.objectToString((Object)user));
            return Collections.emptyList();
        }
        Comparator tComparator = Comparator.reverseOrder();
        bulletins.sort((o1, o2) -> tComparator.compare(o1.getUpdateTime(), o2.getUpdateTime()));
        try {
            String locale = this.userService.getUserLangNameByUserId(userId, tenantId, token);
            traditional = Locale.TAIWAN.toString().equals(locale) ? SystemLanguageUtils.toTraditional((String)JsonUtils.objectToString((Object)bulletins)) : SystemLanguageUtils.toSimple((String)JsonUtils.objectToString((Object)bulletins));
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.GMC_DAP_TRANSLATORS_FAIL.getErrCode(), (Exception)e);
        }
        return (List)JsonUtils.jsonToObject((String)traditional, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

