/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import cn.hutool.core.util.ObjUtil;
import com.digiwin.athena.agiledataecho.dto.EchoExperienceRoleConfigDataQueryDTO;
import com.digiwin.athena.agiledataecho.dto.EchoOpeningRemarksConfigResultDTO;
import com.digiwin.athena.agiledataecho.dto.EchoPageConfigProductBulletinQueryDTO;
import com.digiwin.athena.agiledataecho.dto.EchoPageConfigProductBulletinResultDTO;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoExperienceRoleConfigData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoFuzzyMatchingConfigData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoLiteUploadLimitationsConfigData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoOpeningRemarksConfigData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoProductBulletinConfigData;
import com.digiwin.athena.agiledataecho.proxy.iam.UserService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.KnowledgeMapsService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KMCommandIntentionsDTO;
import com.digiwin.athena.agiledataecho.service.EchoPageConfigService;
import com.digiwin.athena.agiledataecho.util.SystemLanguageUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class EchoPageConfigServiceImpl
implements EchoPageConfigService {
    private static final Logger log = LoggerFactory.getLogger(EchoPageConfigServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private KnowledgeMapsService knowledgeMapsService;
    @Autowired
    private UserService userService;

    public List<EchoPageConfigProductBulletinResultDTO> queryProductBulletinList(AuthoredUser user, EchoPageConfigProductBulletinQueryDTO queryDTO) {
        List echoProductBulletinConfigData;
        Query query = new Query();
        if (StringUtils.isNotBlank((CharSequence)queryDTO.getSource())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"source").regex(queryDTO.getSource(), "i"));
        }
        if (CollectionUtils.isEmpty((Collection)(echoProductBulletinConfigData = this.mongoTemplate.find(query, EchoProductBulletinConfigData.class)))) {
            log.warn("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u516c\u544a\u5217\u8868");
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        echoProductBulletinConfigData.forEach(data -> {
            EchoPageConfigProductBulletinResultDTO gmcProductBulletinResultDTO = new EchoPageConfigProductBulletinResultDTO();
            gmcProductBulletinResultDTO.setId(data.getId());
            gmcProductBulletinResultDTO.setTitle(data.getTitle());
            gmcProductBulletinResultDTO.setContent(data.getContent());
            gmcProductBulletinResultDTO.setCoverUrl(data.getCoverUrl());
            gmcProductBulletinResultDTO.setDocumentList(data.getDocumentList());
            list.add(gmcProductBulletinResultDTO);
        });
        String locale = this.queryUserLocale(user);
        String traditional = Locale.TAIWAN.toString().equals(locale) ? SystemLanguageUtils.toTraditional((String)JsonUtils.objectToString(list)) : SystemLanguageUtils.toSimple((String)JsonUtils.objectToString(list));
        List echoPageConfigProductBulletinResultDTOS = (List)JsonUtils.jsonToObject((String)traditional, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        echoPageConfigProductBulletinResultDTOS.forEach(data -> data.setContent(data.getContent().replace("{assistantName}", queryDTO.getAssistantName())));
        return echoPageConfigProductBulletinResultDTOS;
    }

    public EchoProductBulletinConfigData saveProductBulletinConfig(AuthoredUser user, EchoProductBulletinConfigData saveDTO) {
        try {
            if (StringUtils.isNotBlank((CharSequence)saveDTO.getId())) {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(saveDTO.getId())));
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)Update.fromDocument((Document)Document.parse((String)JsonUtils.objectToString((Object)saveDTO)), (String[])new String[0]), EchoProductBulletinConfigData.class);
                return (EchoProductBulletinConfigData)this.mongoTemplate.findById((Object)saveDTO.getId(), EchoProductBulletinConfigData.class);
            }
            return (EchoProductBulletinConfigData)this.mongoTemplate.insert((Object)saveDTO);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u4ea7\u54c1\u516c\u544a\u914d\u7f6e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public EchoOpeningRemarksConfigData saveOpeningRemarksConfig(AuthoredUser user, EchoOpeningRemarksConfigData saveDTO) {
        try {
            if (StringUtils.isNotBlank((CharSequence)saveDTO.getId())) {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(saveDTO.getId())));
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)Update.fromDocument((Document)Document.parse((String)JsonUtils.objectToString((Object)saveDTO)), (String[])new String[0]), EchoOpeningRemarksConfigData.class);
                return (EchoOpeningRemarksConfigData)this.mongoTemplate.findById((Object)saveDTO.getId(), EchoOpeningRemarksConfigData.class);
            }
            return (EchoOpeningRemarksConfigData)this.mongoTemplate.insert((Object)saveDTO);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u5f00\u573a\u767d\u914d\u7f6e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public EchoOpeningRemarksConfigResultDTO queryOpeningRemarksConfig(AuthoredUser user, EchoPageConfigProductBulletinQueryDTO queryDTO) {
        EchoOpeningRemarksConfigData configData;
        Query query = new Query();
        if (StringUtils.isNotBlank((CharSequence)queryDTO.getSource())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"source").regex(queryDTO.getSource(), "i"));
        }
        if (null == (configData = (EchoOpeningRemarksConfigData)this.mongoTemplate.findOne(query, EchoOpeningRemarksConfigData.class))) {
            return null;
        }
        String token = user.getToken();
        String tenantId = user.getTenantId();
        String userId = user.getUserId();
        String locale = this.queryUserLocale(user);
        EchoOpeningRemarksConfigResultDTO resultDTO = new EchoOpeningRemarksConfigResultDTO();
        resultDTO.setTitle(configData.getTitle());
        resultDTO.setContent(configData.getContent());
        resultDTO.setCoverUrl(configData.getCoverUrl());
        List kmCommandIntentions = this.knowledgeMapsService.queryCommandIntentions(token, userId, tenantId, locale);
        if (CollectionUtils.isNotEmpty((Collection)kmCommandIntentions)) {
            int endIndex;
            kmCommandIntentions.removeIf(intention -> CollectionUtils.isEmpty((Collection)intention.getIntentions()));
            List<KMCommandIntentionsDTO> firstKmIntentions = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)kmCommandIntentions)) {
                String appCode = ((KMCommandIntentionsDTO)kmCommandIntentions.get(0)).getApplicationCode();
                for (KMCommandIntentionsDTO intention2 : kmCommandIntentions) {
                    if (!StringUtils.equals((CharSequence)intention2.getApplicationCode(), (CharSequence)appCode)) continue;
                    firstKmIntentions.add(intention2);
                }
            }
            if (!CollectionUtils.isEmpty(firstKmIntentions = firstKmIntentions.subList(0, endIndex = Math.min(4, firstKmIntentions.size())))) {
                ArrayList<EchoOpeningRemarksConfigResultDTO.Document> documentList = new ArrayList<EchoOpeningRemarksConfigResultDTO.Document>();
                for (KMCommandIntentionsDTO model : firstKmIntentions) {
                    if (CollectionUtils.isEmpty((Collection)model.getIntentions())) continue;
                    EchoOpeningRemarksConfigResultDTO.Document document = new EchoOpeningRemarksConfigResultDTO.Document();
                    document.setIndex(model.getIntentionGroupName());
                    if (CollectionUtils.isNotEmpty((Collection)model.getIntentions())) {
                        document.setIntention(((KMCommandIntentionsDTO.Intention)model.getIntentions().get(0)).getIntention());
                    }
                    documentList.add(document);
                }
                resultDTO.setDocumentList(documentList);
            }
        }
        String traditional = Locale.TAIWAN.toString().equals(locale) ? SystemLanguageUtils.toTraditional((String)JsonUtils.objectToString((Object)resultDTO)) : SystemLanguageUtils.toSimple((String)JsonUtils.objectToString((Object)resultDTO));
        EchoOpeningRemarksConfigResultDTO echoOpeningRemarksConfigResultDTO = (EchoOpeningRemarksConfigResultDTO)JsonUtils.jsonToObject((String)traditional, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        echoOpeningRemarksConfigResultDTO.setTitle(echoOpeningRemarksConfigResultDTO.getTitle().replace("{assistantName}", queryDTO.getAssistantName()));
        echoOpeningRemarksConfigResultDTO.setContent(echoOpeningRemarksConfigResultDTO.getContent().replace("{assistantName}", queryDTO.getAssistantName()));
        return echoOpeningRemarksConfigResultDTO;
    }

    public List<EchoExperienceRoleConfigData> queryExperienceRoleConfigList(EchoExperienceRoleConfigDataQueryDTO queryDTO) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"deleted").is((Object)false));
        List echoExperienceRoleConfigData = this.mongoTemplate.find(query, EchoExperienceRoleConfigData.class);
        echoExperienceRoleConfigData.forEach(data -> data.setRoleName(queryDTO.getDistrict(), queryDTO.getLocale()));
        return echoExperienceRoleConfigData;
    }

    public EchoLiteUploadLimitationsConfigData queryLiteUploadLimitationsConfig(AuthoredUser user) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"deleted").is((Object)false));
        EchoLiteUploadLimitationsConfigData one = (EchoLiteUploadLimitationsConfigData)this.mongoTemplate.findOne(query, EchoLiteUploadLimitationsConfigData.class);
        if (one != null) {
            one.setHtmlString(this.queryUserLocale(user));
        }
        return one;
    }

    public List<KMCommandIntentionsDTO> queryCommandIntentions(AuthoredUser user) {
        String locale = this.queryUserLocale(user);
        return this.knowledgeMapsService.queryCommandIntentions(user.getToken(), user.getUserId(), user.getTenantId(), locale);
    }

    public EchoFuzzyMatchingConfigData queryFuzzyMatchingConfig(AuthoredUser user) {
        EchoFuzzyMatchingConfigData one = (EchoFuzzyMatchingConfigData)this.mongoTemplate.findOne(new Query(), EchoFuzzyMatchingConfigData.class);
        if (ObjUtil.isEmpty((Object)one)) {
            EchoFuzzyMatchingConfigData data = new EchoFuzzyMatchingConfigData();
            data.setFuzzyMatching(true);
            data.setPrecision(Double.valueOf(0.9));
            return data;
        }
        return one;
    }

    private String queryUserLocale(AuthoredUser user) {
        String token = user.getToken();
        String userId = user.getUserId();
        String tenantId = user.getTenantId();
        return this.userService.getUserLangNameByUserId(userId, tenantId, token);
    }
}

