/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.dto.UserDefineHabitualDTO;
import com.digiwin.athena.agiledataecho.service.UserDefineHabitualStorage;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class UserDefineHabitualStorageImpl
implements UserDefineHabitualStorage {
    private static final String USER_DEFINE_HABITUAL_KEY = "HABITUAL";
    private static final String MONGODB_COLLECTION_NAME = "agile_data_user_define";
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;

    public boolean saveUserHabitual(UserDefineHabitualDTO userDefineHabitualDTO, AuthoredUser authoredUser) {
        if (userDefineHabitualDTO == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("type").is((Object)USER_DEFINE_HABITUAL_KEY));
        AgileDataUserDefine agileDataUserDefine = (AgileDataUserDefine)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if (agileDataUserDefine == null) {
            AgileDataUserDefine userDefine = new AgileDataUserDefine();
            userDefine.setUserId(authoredUser.getUserId());
            userDefine.setTenantId(authoredUser.getTenantId());
            userDefine.setType(USER_DEFINE_HABITUAL_KEY);
            userDefine.setProbe(userDefineHabitualDTO.getProbe());
            this.mongoAgileDataPageViewTemplate.insert((Object)userDefine, MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("probe", (Object)userDefineHabitualDTO.getProbe());
            this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public AgileDataUserDefine getUserHabitual(AuthoredUser authoredUser) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("type").is((Object)USER_DEFINE_HABITUAL_KEY));
        return (AgileDataUserDefine)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
    }
}

