/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.component.grid;

import com.digiwin.athena.show.component.grid.CharCounter;
import com.digiwin.athena.show.metadata.MetadataField;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WidthCalculator {
    public static final String BUTTON_GROUP_COMPONENT_TYPE = "BUTTON_GROUP";
    public static final int COL_MAX_WIDTH = 400;

    public static void calColumnWidth(List<MetadataField> metadataFields, List<Map<String, Object>> pageData) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        int maxRow = 20;
        double chCharWidth = 13.0;
        double enCharWidth = 8.0;
        int otherCharWidth = 7;
        int paddingWidth = 16;
        int headerIconWidth = 34;
        int multiColumnIconWidth = 17;
        if (pageData != null && pageData.size() > 0) {
            if (pageData.size() < 20) {
                maxRow = pageData.size();
            }
            CharCounter charCounter = new CharCounter();
            pageData.stream().limit(maxRow).forEach(data -> {
                for (MetadataField field : metadataFields) {
                    if (!data.containsKey(field.getName())) {
                        return;
                    }
                    Object value = data.get(field.getName());
                    if (value == null) {
                        return;
                    }
                    if (value instanceof Map || value instanceof Collection) {
                        return;
                    }
                    CharCounter.Result result = charCounter.count(value.toString());
                    if (result == null) continue;
                    int width = (int)Math.ceil((double)result.getChCharacter() * chCharWidth + (double)result.getEnUpCharacter() * chCharWidth + (double)result.getEnNumberSpaceCharacter() * enCharWidth + (double)(result.getOtherCharacter() * otherCharWidth));
                    field.setDisplayWidth(width + field.getDisplayWidth());
                }
            });
        }
        for (MetadataField field : metadataFields) {
            if (field.getDisplayWidth() <= 0) continue;
            field.setDisplayWidth((int)Math.ceil((double)field.getDisplayWidth() * 1.0 / ((double)maxRow * 1.0)));
        }
        for (MetadataField metadataField : metadataFields) {
            int maxWidth = 0;
            if (metadataField.getDescription() != null) {
                maxWidth = (int)Math.ceil((double)metadataField.getDescription().length() * chCharWidth) + headerIconWidth;
            }
            if (CollectionUtils.isNotEmpty((Collection)metadataField.getSubFields()) && metadataField.getSubFields().size() > 1) {
                maxWidth += multiColumnIconWidth;
            }
            boolean needSetWidth = false;
            if (CollectionUtils.isNotEmpty((Collection)metadataField.getSubFields())) {
                if (metadataField.getSubFields().size() > 1) {
                    maxWidth += multiColumnIconWidth;
                }
                for (MetadataField subField : metadataField.getSubFields()) {
                    if (subField.getDisplayWidth() <= 0) continue;
                    needSetWidth = true;
                    if (subField.getDisplayWidth() <= maxWidth) continue;
                    maxWidth = subField.getDisplayWidth();
                }
            } else if (metadataField.getDisplayWidth() > 0) {
                needSetWidth = true;
                if (metadataField.getDisplayWidth() > maxWidth) {
                    maxWidth = metadataField.getDisplayWidth();
                }
            }
            if (metadataField.getDisplayWidth() != 0 && !needSetWidth) continue;
            int displayWidth = maxWidth + paddingWidth;
            WidthCalculator.widthLimit((MetadataField)metadataField, (int)displayWidth);
        }
    }

    public static void widthLimit(MetadataField metadataField, int displayWidth) {
        metadataField.setDisplayWidth(Math.min(displayWidth, 400));
    }
}

