/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.manager.themeMap.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ThemeAgileDataServiceImpl
implements ThemeAgileDataService {
    private static final Logger log = LoggerFactory.getLogger(ThemeAgileDataServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(ThemeAgileDataServiceImpl.class);
    @Autowired
    private EchoEnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    public AgileReportKMData querySceneMaps(String code) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/querySceneMaps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HashMap sceneMap = Maps.newHashMap();
        sceneMap.put("code", code);
        HttpEntity requestEntity = new HttpEntity((Object)sceneMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)sceneMap);
            return (AgileReportKMData)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            String message = this.messageUtils.getMessage("exception.agiledata.scenced.error");
            throw BusinessException.create((String)message);
        }
    }

    public List<AgileDataRelationDTO> queryActionRelation(List<String> actionIds) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/queryActionRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HashMap relationMap = Maps.newHashMap();
        relationMap.put("actionIds", actionIds);
        HttpEntity requestEntity = new HttpEntity((Object)relationMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)relationMap);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<AgileReportKMData> querySceneMapsByActionId(List<String> actionIds) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/queryActionReportConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HashMap sceneMap = Maps.newHashMap();
        sceneMap.put("actionIds", actionIds);
        HttpEntity requestEntity = new HttpEntity((Object)sceneMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)sceneMap);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public String findLastNodeShapeType(Map<String, Object> chartParams) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "knowledgegraph/Action/findLastNodeShapeType";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HttpEntity httpEntity = new HttpEntity(chartParams, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map result = (Map)responseEntity.getBody();
            if (result.containsKey("response")) {
                return MapUtils.getString((Map)result, (Object)"response");
            }
            return null;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public ThemeMapBoardDTO getThemeMapBoard(String boardId) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "knowledgegraph/dataBoard/queryBoardById";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HashMap params = Maps.newHashMap();
        params.put("boardId", boardId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u770b\u677f\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (ThemeMapBoardDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public ThemeMapBoardDTO.DataBoardQuestion getThemeMapBoardQuestion(String questionId) {
        String url = this.envProperties.getKnowledgeMapsUrl() + "/restful/service/knowledgegraph/dataBoard/queryDataBoardConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", this.getToken());
        HashMap params = Maps.newHashMap();
        params.put("questionId", questionId);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u770b\u677f\u95ee\u9898\u4fe1\u606f\u8fd4\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (ThemeMapBoardDTO.DataBoardQuestion)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        }
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }
}

