/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.metadata;

import com.digiwin.athena.show.metadata.MetadataField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class ApiMetadata
implements Serializable {
    private String actionId;
    private String serviceName;
    private List<MetadataField> requestFields;
    private Map<String, MetadataField> requestFieldMap = new HashMap();
    private List<MetadataField> responseFields;
    private String sceneNodeType;
    private String showType;
    private String name;
    private Map<String, MetadataField> responseFieldMap = new HashMap();

    public void addResponseFields(List<MetadataField> fields) {
        if (this.responseFields == null) {
            this.responseFields = new ArrayList();
        }
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (this.responseFields.isEmpty()) {
            this.responseFields.addAll(fields);
        } else {
            if (((MetadataField)this.responseFields.get(0)).getSubFields() == null) {
                ((MetadataField)this.responseFields.get(0)).setSubFields(new ArrayList());
            }
            HashSet<String> allFields = new HashSet<String>();
            for (MetadataField subField : ((MetadataField)this.responseFields.get(0)).getSubFields()) {
                allFields.add(subField.getName());
            }
            for (MetadataField field : fields) {
                if (!allFields.contains(field.getName())) {
                    ((MetadataField)this.responseFields.get(0)).getSubFields().add(field);
                    continue;
                }
                Optional<MetadataField> existFieldOptional = ((MetadataField)this.responseFields.get(0)).getSubFields().stream().filter(x -> Objects.equals(x.getName(), field.getName())).findFirst();
                if (!existFieldOptional.isPresent()) continue;
                MetadataField existFiled = existFieldOptional.get();
                List subFields = existFiled.getSubFields();
                List sourceSubFields = field.getSubFields();
                if (CollectionUtils.isEmpty((Collection)subFields)) {
                    ((MetadataField)this.responseFields.get(0)).getSubFields().remove(existFiled);
                    ((MetadataField)this.responseFields.get(0)).getSubFields().add(field);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)sourceSubFields)) continue;
                this.mergeMetadataField(sourceSubFields, subFields);
            }
        }
    }

    private void mergeMetadataField(List<MetadataField> sourceFields, List<MetadataField> targetFields) {
        Iterator<MetadataField> iterator = sourceFields.iterator();
        while (iterator.hasNext()) {
            MetadataField next = iterator.next();
            String name = next.getName();
            List subFields = next.getSubFields();
            int index = -1;
            for (int i = 0; i < targetFields.size(); ++i) {
                MetadataField metadataField = targetFields.get(i);
                if (!Objects.equals(metadataField.getName(), name)) continue;
                index = i;
            }
            if (index <= -1) continue;
            MetadataField metadataField = targetFields.get(index);
            List subTargetFields = metadataField.getSubFields();
            if (CollectionUtils.isNotEmpty((Collection)subTargetFields)) {
                iterator.remove();
                if (!CollectionUtils.isNotEmpty((Collection)subFields)) continue;
                this.mergeMetadataField(subFields, subTargetFields);
                continue;
            }
            targetFields.remove(index);
        }
        if (CollectionUtils.isNotEmpty(sourceFields)) {
            targetFields.addAll(sourceFields);
        }
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<MetadataField> getRequestFields() {
        return this.requestFields;
    }

    public Map<String, MetadataField> getRequestFieldMap() {
        return this.requestFieldMap;
    }

    public List<MetadataField> getResponseFields() {
        return this.responseFields;
    }

    public String getSceneNodeType() {
        return this.sceneNodeType;
    }

    public String getShowType() {
        return this.showType;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, MetadataField> getResponseFieldMap() {
        return this.responseFieldMap;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRequestFields(List<MetadataField> requestFields) {
        this.requestFields = requestFields;
    }

    public void setRequestFieldMap(Map<String, MetadataField> requestFieldMap) {
        this.requestFieldMap = requestFieldMap;
    }

    public void setResponseFields(List<MetadataField> responseFields) {
        this.responseFields = responseFields;
    }

    public void setSceneNodeType(String sceneNodeType) {
        this.sceneNodeType = sceneNodeType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResponseFieldMap(Map<String, MetadataField> responseFieldMap) {
        this.responseFieldMap = responseFieldMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiMetadata)) {
            return false;
        }
        ApiMetadata other = (ApiMetadata)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$actionId = this.getActionId();
        String other$actionId = other.getActionId();
        if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        List this$requestFields = this.getRequestFields();
        List other$requestFields = other.getRequestFields();
        if (this$requestFields == null ? other$requestFields != null : !((Object)this$requestFields).equals(other$requestFields)) {
            return false;
        }
        Map this$requestFieldMap = this.getRequestFieldMap();
        Map other$requestFieldMap = other.getRequestFieldMap();
        if (this$requestFieldMap == null ? other$requestFieldMap != null : !((Object)this$requestFieldMap).equals(other$requestFieldMap)) {
            return false;
        }
        List this$responseFields = this.getResponseFields();
        List other$responseFields = other.getResponseFields();
        if (this$responseFields == null ? other$responseFields != null : !((Object)this$responseFields).equals(other$responseFields)) {
            return false;
        }
        String this$sceneNodeType = this.getSceneNodeType();
        String other$sceneNodeType = other.getSceneNodeType();
        if (this$sceneNodeType == null ? other$sceneNodeType != null : !this$sceneNodeType.equals(other$sceneNodeType)) {
            return false;
        }
        String this$showType = this.getShowType();
        String other$showType = other.getShowType();
        if (this$showType == null ? other$showType != null : !this$showType.equals(other$showType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map this$responseFieldMap = this.getResponseFieldMap();
        Map other$responseFieldMap = other.getResponseFieldMap();
        return !(this$responseFieldMap == null ? other$responseFieldMap != null : !((Object)this$responseFieldMap).equals(other$responseFieldMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $actionId = this.getActionId();
        result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        List $requestFields = this.getRequestFields();
        result = result * 59 + ($requestFields == null ? 43 : ((Object)$requestFields).hashCode());
        Map $requestFieldMap = this.getRequestFieldMap();
        result = result * 59 + ($requestFieldMap == null ? 43 : ((Object)$requestFieldMap).hashCode());
        List $responseFields = this.getResponseFields();
        result = result * 59 + ($responseFields == null ? 43 : ((Object)$responseFields).hashCode());
        String $sceneNodeType = this.getSceneNodeType();
        result = result * 59 + ($sceneNodeType == null ? 43 : $sceneNodeType.hashCode());
        String $showType = this.getShowType();
        result = result * 59 + ($showType == null ? 43 : $showType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map $responseFieldMap = this.getResponseFieldMap();
        result = result * 59 + ($responseFieldMap == null ? 43 : ((Object)$responseFieldMap).hashCode());
        return result;
    }

    public String toString() {
        return "ApiMetadata(actionId=" + this.getActionId() + ", serviceName=" + this.getServiceName() + ", requestFields=" + this.getRequestFields() + ", requestFieldMap=" + this.getRequestFieldMap() + ", responseFields=" + this.getResponseFields() + ", sceneNodeType=" + this.getSceneNodeType() + ", showType=" + this.getShowType() + ", name=" + this.getName() + ", responseFieldMap=" + this.getResponseFieldMap() + ")";
    }
}

