/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataFilter;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenModel;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.service.AgileDataThemeMapDefine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileDataScreenThemeMapDefine
extends AgileDataThemeMapDefine {
    @Autowired
    private AdtService adtService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static final String keyPrefix = "adt:cache:AGILEDATA_SCREEN_";

    public String supportKey() {
        return "AGILE_DATA_DEFINE_1";
    }

    public void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        if (StringUtils.isNotEmpty((String)agileReportKMData.getLayoutId())) {
            AgileDataScreenModel agileDataScreenModel;
            String models = (String)this.redisTemplate.opsForValue().get((Object)(keyPrefix + agileReportKMData.getLayoutId()));
            if (StringUtils.isNotEmpty((String)models)) {
                agileDataScreenModel = (AgileDataScreenModel)JsonUtils.jsonToObject((String)models, AgileDataScreenModel.class);
            } else {
                agileDataScreenModel = this.adtService.getAgileDataScreenModel(agileReportKMData.getLayoutId(), executeContext.getLocale());
                if (agileDataScreenModel != null) {
                    this.redisTemplate.opsForValue().set((Object)(keyPrefix + agileReportKMData.getLayoutId()), (Object)JsonUtils.objectToString((Object)agileDataScreenModel));
                }
            }
            if (agileDataScreenModel != null) {
                String screenActionIds = agileReportKMData.getActionId();
                ArrayList filterActionId = Lists.newArrayList();
                executeContext.getAgileData().put("screenModel", agileDataScreenModel);
                agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> {
                    if (!CollectionUtils.isEmpty((Collection)type.getFilter())) {
                        filterActionId.addAll(type.getFilter().stream().map(AgileDataFilter::getActionId).collect(Collectors.toList()));
                    }
                }));
                if (!CollectionUtils.isEmpty((Collection)filterActionId)) {
                    ArrayList actionIds = Lists.newArrayList(Arrays.asList(agileReportKMData.getActionId().split(",")));
                    actionIds.removeAll(filterActionId);
                    screenActionIds = String.join((CharSequence)",", actionIds);
                }
                executeContext.getAgileData().put("screenActionIds", screenActionIds);
            }
        }
    }

    public Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return false;
    }
}

