/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataTag;
import com.digiwin.athena.show.domain.agileDataDTO.AgileKMConditionItem;
import com.digiwin.athena.show.domain.agileDataDTO.AgileKMConditionLimitCondition;
import com.digiwin.athena.show.domain.agileDataDTO.AgileKMConditionLimitRecast;
import com.digiwin.athena.show.domain.agileDataDTO.AgileKMConditionLimitStatistic;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportCardDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportIndex;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileDataBusinessEnum;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import com.digiwin.athena.show.service.AgileDataThemeMapDefine;
import com.digiwin.athena.show.service.AgileDataTransDefineService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.mapstruct.ap.internal.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileDataPageDefineThemeMapService
extends AgileDataPageDefineService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataPageDefineThemeMapService.class);
    private static final List<String> DATE_FIELDS = Lists.newArrayList((Object[])new String[]{"date", "datetime"});
    @Autowired
    private ThemeAgileDataService themeAgileDataService;
    @Autowired
    private EchoInformationService echoInformationService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private AgileDataTransDefineService agileDataTransDefineService;
    @Autowired
    private List<AgileDataThemeMapDefine> agileDataThemeMapDefines;
    private static final String AGILE_DATA_DESCRIPTION = "\u7f3a\u5c11%s\u5b57\u6bb5\u8bbe\u5b9a\uff0c\u65e0\u6cd5\u5448\u73b0\u56fe\u5f62";
    private static final String AGILE_DATA_CONTENT = "\u5f53\u524d\u53d6\u5f97\u7684\u5404\u4e2a\u5b57\u6bb5\u7684\u4e2d\u82f1\u6587\u540d\u79f0\u53ca\u5176\u5bf9\u5e94%s";
    private static final String AGILE_DATA_EXTEND = "\u56fe\u5f62\u9700\u7ef4\u5ea6\u5ea6\u91cf\u81f3\u5c11\u5404\u6709\u4e00\u4e2a\uff0c\u6307\u6807\u5361\u9700\u81f3\u5c11\u4e00\u4e2a\u5ea6\u91cf\uff0c\u624d\u53ef\u5448\u73b0\uff0c\u8bf7\u4fee\u6539\u5b57\u6bb5\u5bf9\u5e94\u7ef4\u5ea6/\u5ea6\u91cf\uff0c\u6216\u8005\u589e\u52a0\u65b0\u7684\u7ef4\u5ea6/\u5ea6\u91cf\u5b57\u6bb5";

    public String supportKey() {
        return "AGILEDATA_DEFINE_0";
    }

    private AgileDataThemeMapDefine getPageDefine(ExecuteContext executeContext) {
        String entry = MapUtils.getString((Map)executeContext.getAgileData(), (Object)"entry", (String)"0");
        AgileDataThemeMapDefine agileDataPageDefineService = null;
        for (AgileDataThemeMapDefine pageDefine : this.agileDataThemeMapDefines) {
            String supportKey = "AGILE_DATA_DEFINE_" + entry;
            if (!StringUtils.equals((String)pageDefine.supportKey(), (String)supportKey)) continue;
            agileDataPageDefineService = pageDefine;
            break;
        }
        return agileDataPageDefineService;
    }

    protected void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        Objects.requireNonNull(this.getPageDefine(executeContext)).buildScreenModel(agileReportKMData, executeContext);
    }

    protected Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return Objects.requireNonNull(this.getPageDefine(executeContext)).judgeDefine(judgeCode, executeContext, apiMetadata, agileDataListList, targetDTO, pageData);
    }

    protected AgileReportKMData getAgileReportDefine(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        String code = executeContext.getReportCode();
        AgileReportKMData agileReportKMData = snapDataDTO.getShowDefine() != null && snapDataDTO.getShowDefine().getShowType() != null ? this.getAgileReportKMData(snapDataDTO) : this.getSceneAgileReportKMData(snapDataDTO, code, executeContext);
        this.completionDefine(agileReportKMData, executeContext, snapDataDTO);
        return agileReportKMData;
    }

    private AgileReportKMData getSceneAgileReportKMData(SnapDataDTO snapDataDTO, String code, ExecuteContext executeContext) {
        String transId;
        AgileReportKMData agileReportKMData = null;
        if (StringUtils.isNotEmpty((String)code)) {
            agileReportKMData = this.themeAgileDataService.querySceneMaps(code);
        }
        if (agileReportKMData == null) {
            agileReportKMData = this.getAgileReportKMData(snapDataDTO.getPageData());
        }
        if (StringUtils.isNotEmpty((String)(transId = executeContext.getTransId())) && agileReportKMData != null) {
            agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> type.setValue(Integer.valueOf(transId))));
        }
        return agileReportKMData;
    }

    private void completionDefine(AgileReportKMData agileReportKMData, ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        if (agileReportKMData == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)agileReportKMData.getShow())) {
            agileReportKMData.setShow((List)Lists.newArrayList());
        }
        agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> {
            AgileReportShow showInfo;
            String actionId = showType.getActionId();
            Optional<AgileReportShow> optionalShow = agileReportKMData.getShow().stream().filter(show -> StringUtils.equals((String)actionId, (String)show.getActionId())).findFirst();
            if (optionalShow.isPresent()) {
                showInfo = optionalShow.get();
            } else {
                showInfo = new AgileReportShow();
                showInfo.setActionId(actionId);
                agileReportKMData.getShow().add(showInfo);
            }
            ApiMetadata apiMetadata = this.getApiMetadata(snapDataDTO, executeContext, actionId);
            if (apiMetadata == null) {
                return;
            }
            this.transTable(apiMetadata, type);
            Integer showValue = type.getValue() == null ? 0 : type.getValue();
            this.completionMetadataField(apiMetadata, snapDataDTO, actionId);
            showInfo.setTargetSource(super.getTargetSource(apiMetadata));
            this.agileDataTransDefineService.transEchartsDefine(type, showInfo, snapDataDTO, apiMetadata, actionId, showInfo.getTargetSource());
            switch (showValue) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.completionEchartsDefine(showInfo, agileReportKMData, apiMetadata, executeContext);
                    break;
                }
                case 7: {
                    this.completionCardDefine(showInfo);
                    break;
                }
                case 2: {
                    this.completionIndexDefine(showInfo, apiMetadata);
                    break;
                }
            }
        }));
    }

    private void transTable(ApiMetadata apiMetadata, AgileReportShowTypeInfoDTO showType) {
        ArrayList dimensionFields = Lists.newArrayList();
        apiMetadata.getResponseFields().forEach(metadataField -> {
            if (metadataField.isObjectField()) {
                dimensionFields.addAll(this.getDimensionFields(metadataField));
            }
        });
        if (CollectionUtils.isEmpty((Collection)dimensionFields)) {
            return;
        }
        if (dimensionFields.size() > 1) {
            showType.setValue(Integer.valueOf(0));
        }
    }

    private List<MetadataField> getDimensionFields(MetadataField metadataField) {
        ArrayList metadataFields = Lists.newArrayList();
        if (metadataField.isObjectField()) {
            metadataField.getSubFields().stream().forEach(subField -> metadataFields.addAll(this.getDimensionFields(subField)));
        } else if (!StringUtils.equals((String)"numeric", (String)metadataField.getDataType())) {
            metadataFields.add(metadataField);
        }
        return metadataFields;
    }

    private void completionMetadataField(ApiMetadata apiMetadata, SnapDataDTO snapDataDTO, String actionId) {
        if (MapUtils.isNotEmpty((Map)snapDataDTO.getPageData()) && snapDataDTO.getPageData().containsKey(actionId) && !CollectionUtils.isEmpty((Collection)apiMetadata.getResponseFields())) {
            apiMetadata.getResponseFields().stream().forEach(metadataField -> this.completionDecimal(metadataField));
        }
    }

    private void completionDecimal(MetadataField metadataField) {
        if (metadataField.isObjectField()) {
            metadataField.getSubFields().stream().forEach(subField -> this.completionDecimal(subField));
        } else if (metadataField.getDecimal() == null && "numeric".equals(metadataField.getDataType())) {
            if (AgileDataBusinessEnum.isAmountType((String)metadataField.getBusinessType()).booleanValue()) {
                metadataField.setDecimal(Integer.valueOf(2));
            } else {
                metadataField.setDecimal(Integer.valueOf(0));
            }
        }
    }

    private void completionIndexDefine(AgileReportShow showInfo, ApiMetadata apiMetadata) {
        if (showInfo.getAgileReportIndex() == null) {
            ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata((String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata);
            ApiMetadataUtil.flatMetaData((ApiMetadata)masterApi);
            List metadataFields = ConvertGetAgileData.getTargetFiled((String)showInfo.getTargetSource(), (ApiMetadata)masterApi);
            AgileReportIndex agileReportIndex = new AgileReportIndex();
            ArrayList indexes = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)metadataFields)) {
                metadataFields.stream().forEach(metadataField -> {
                    AgileReportIndex.AgileDataDefineIndex agileDataDefineIndex = new AgileReportIndex.AgileDataDefineIndex();
                    AgileReportRuleInfoDTO agileReportRuleInfoDTO = new AgileReportRuleInfoDTO();
                    agileReportRuleInfoDTO.setApplyToField(metadataField.getName());
                    agileDataDefineIndex.setTitle(agileReportRuleInfoDTO);
                    agileDataDefineIndex.setValue(agileReportRuleInfoDTO);
                    indexes.add(agileDataDefineIndex);
                });
            }
            agileReportIndex.setIndexes((List)indexes);
            showInfo.setAgileReportIndex(agileReportIndex);
        }
    }

    private void completionCardDefine(AgileReportShow showInfo) {
        if (CollectionUtils.isEmpty((Collection)showInfo.getAgileRule())) {
            return;
        }
        Optional<AgileReportRuleDTO> agileReportRuleDTOOptional = showInfo.getAgileRule().stream().filter(rule -> StringUtils.equals((String)"card", (String)rule.getType())).findFirst();
        AgileReportRuleDTO ruleDTO = agileReportRuleDTOOptional.orElse(null);
        if (ruleDTO == null) {
            return;
        }
        AgileReportCardDTO agileReportCard = new AgileReportCardDTO();
        ruleDTO.getRules().stream().forEach(rule -> {
            switch (rule.getType()) {
                case "header": {
                    AgileReportCardDTO.AgileReportCardInfo header = new AgileReportCardDTO.AgileReportCardInfo();
                    header.setAreaDefine(rule.getAreaDefine());
                    header.setType(rule.getType());
                    agileReportCard.setHeader(header);
                    break;
                }
                case "body": {
                    AgileReportCardDTO.AgileReportCardInfo body = new AgileReportCardDTO.AgileReportCardInfo();
                    body.setAreaDefine(rule.getAreaDefine());
                    body.setFieldsLayout(rule.getFieldsLayout());
                    body.setType(rule.getType());
                    agileReportCard.setBody(body);
                    break;
                }
                case "footer": {
                    AgileReportCardDTO.AgileReportCardInfo footer = new AgileReportCardDTO.AgileReportCardInfo();
                    footer.setAreaDefine(rule.getAreaDefine());
                    footer.setFieldsLayout(rule.getFieldsLayout());
                    footer.setType(rule.getType());
                    agileReportCard.setFooter(footer);
                    break;
                }
            }
        });
        showInfo.setCard(agileReportCard);
    }

    private void completionEchartsDefine(AgileReportShow showInfo, AgileReportKMData agileReportKMData, ApiMetadata apiMetadata, ExecuteContext executeContext) {
        if (CollectionUtils.isEmpty((Collection)showInfo.getEChart())) {
            ArrayList eChartDefineDTOList = Lists.newArrayList();
            AgileReportDataFindDTO xAxis = new AgileReportDataFindDTO();
            List xaxisMetadataFields = ConvertGetAgileData.getStringField((String)"numeric", (String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)false);
            if (CollectionUtils.isEmpty((Collection)xaxisMetadataFields)) {
                if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
                    EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                    echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()).longValue());
                    echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "\u7ef4\u5ea6"));
                    echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "\u7ef4\u5ea6"));
                    echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                    this.echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                    agileReportKMData.getShow().remove(showInfo);
                    throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                }
                return;
            }
            MetadataField metadataField = (MetadataField)xaxisMetadataFields.get(0);
            xAxis.setApplyToField(metadataField.getName());
            xAxis.setTitle(metadataField.getDescription());
            Optional<Object> agileReportRuleDTOOptional = Optional.empty();
            if (!CollectionUtils.isEmpty((Collection)showInfo.getAgileRule())) {
                agileReportRuleDTOOptional = showInfo.getAgileRule().stream().filter(rule -> StringUtils.equals((String)"doubleShaft", (String)rule.getType())).findFirst();
            }
            if (agileReportRuleDTOOptional.isPresent()) {
                ApiMetadata masterMetadata = ConvertGetAgileData.getMasterMetadata((String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata);
                Map filedMap = ConvertGetAgileData.getFiledMap((String)showInfo.getTargetSource(), (ApiMetadata)masterMetadata);
                ((AgileReportRuleDTO)agileReportRuleDTOOptional.get()).getRules().sort(Comparator.comparing(direction -> "left".equals(direction.getDirection()) ? 0 : 1));
                ((AgileReportRuleDTO)agileReportRuleDTOOptional.get()).getRules().stream().forEach(rule -> {
                    AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
                    eChart.setXAxis(xAxis);
                    ArrayList series = Lists.newArrayList();
                    rule.getAreaDefine().stream().forEach(area -> area.getApplyToFields().stream().forEach(areaField -> {
                        MetadataField field = (MetadataField)filedMap.get(areaField);
                        if (field == null) {
                            if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
                                EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                                echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()).longValue());
                                echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "\u5ea6\u91cf"));
                                echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "\u5ea6\u91cf"));
                                echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                                this.echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                                agileReportKMData.getShow().remove(showInfo);
                                throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                            }
                            return;
                        }
                        AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                        seriesDTO.setApplyToField(field.getName());
                        seriesDTO.setTitle(field.getDescription());
                        seriesDTO.setChart(area.getChart());
                        series.add(seriesDTO);
                    }));
                    eChart.setSeries((List)series);
                    eChartDefineDTOList.add(eChart);
                });
            } else {
                AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
                eChart.setXAxis(xAxis);
                ArrayList series = Lists.newArrayList();
                List seriesMetadataFields = ConvertGetAgileData.getStringField((String)"numeric", (String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)true);
                if (CollectionUtils.isEmpty((Collection)seriesMetadataFields)) {
                    if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
                        EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                        echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()).longValue());
                        echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "\u5ea6\u91cf"));
                        echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "\u5ea6\u91cf"));
                        echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                        this.echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                        agileReportKMData.getShow().remove(showInfo);
                        throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                    }
                    return;
                }
                seriesMetadataFields.stream().forEach(serieMetadataField -> {
                    AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                    seriesDTO.setApplyToField(serieMetadataField.getName());
                    series.add(seriesDTO);
                });
                eChart.setSeries((List)series);
                eChartDefineDTOList.add(eChart);
            }
            showInfo.setEChart((List)eChartDefineDTOList);
        }
    }

    protected ApiMetadata getApiMetadata(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        boolean isNeedKM;
        ApiMetadata apiMetadata = null;
        boolean bl = isNeedKM = !StringUtils.equals((String)"2", (String)snapDataDTO.getLink());
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map actionMap = Maps.newHashMap();
            Map metadataMap = Maps.newHashMap();
            if (obj instanceof Map) {
                actionMap = (Map)obj;
            } else {
                List metadataList = (List)obj;
                if (!CollectionUtils.isEmpty((Collection)metadataList)) {
                    actionMap = (Map)metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty((Map)actionMap) && actionMap.containsKey("metadata")) {
                metadataMap = MapUtils.getMap(actionMap, (Object)"metadata");
            }
            MetadataDataDTO metadataDataDTO = null;
            if (MapUtils.isNotEmpty((Map)metadataMap)) {
                metadataDataDTO = (MetadataDataDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)metadataMap), MetadataDataDTO.class);
            }
            if (metadataDataDTO != null) {
                apiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).createApiMetadata(metadataDataDTO);
                if (isNeedKM) {
                    ApiMetadata originalApiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).getMetadata(executeContext.getLocale(), actionId);
                    if (actionMap != null && originalApiMetadata != null) {
                        apiMetadata.setSceneNodeType(originalApiMetadata.getSceneNodeType());
                        apiMetadata.setName(originalApiMetadata.getName());
                        apiMetadata.setServiceName(originalApiMetadata.getServiceName());
                        apiMetadata.setActionId(originalApiMetadata.getActionId());
                    }
                } else {
                    apiMetadata.setActionId(actionId);
                }
            }
        }
        if (isNeedKM && apiMetadata == null) {
            try {
                apiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).getMetadata(executeContext.getLocale(), actionId);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6KM\u5143\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        this.completionMetadataTag(apiMetadata, snapDataDTO, actionId, executeContext);
        return apiMetadata;
    }

    private void completionMetadataTag(ApiMetadata apiMetadata, SnapDataDTO snapDataDTO, String actionId, ExecuteContext executeContext) {
        AgileDataTag agileDataTag = this.getAgileDataTag(snapDataDTO, executeContext, actionId);
        if (agileDataTag == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)agileDataTag.getFields())) {
            return;
        }
        MetadataField rootMetadataField = ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata);
        Map metadataMap = ConvertGetAgileData.getAgileData((String)rootMetadataField.getName(), (ApiMetadata)apiMetadata);
        agileDataTag.getFields().stream().forEach(valueField -> {
            String field = MapUtils.getString((Map)valueField, (Object)"field", (String)"");
            MetadataField metadataField = (MetadataField)metadataMap.get(field);
            if (metadataField != null) {
                metadataField.setBusinessType(MapUtils.getString((Map)valueField, (Object)"businessType", (String)""));
                metadataField.setDecimalRule(MapUtils.getString((Map)valueField, (Object)"decimalRule"));
                metadataField.setExplanation(MapUtils.getString((Map)valueField, (Object)"explanation", (String)""));
                metadataField.setUnit(MapUtils.getString((Map)valueField, (Object)"dataUnit"));
            }
        });
    }

    protected AgileDataTag getAgileDataTag(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        AgileDataTag agileDataTag = null;
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map actionMap = Maps.newHashMap();
            if (obj instanceof Map) {
                actionMap = (Map)obj;
            } else {
                List metadataList = (List)obj;
                if (!CollectionUtils.isEmpty((Collection)metadataList)) {
                    actionMap = (Map)metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty((Map)actionMap) && actionMap.containsKey("dataTag")) {
                Map dataTagMap = MapUtils.getMap(actionMap, (Object)"dataTag");
                agileDataTag = (AgileDataTag)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataTagMap), AgileDataTag.class);
            }
        }
        if (agileDataTag == null && snapDataDTO.getShowDefine() != null) {
            agileDataTag = snapDataDTO.getShowDefine().getDataTag();
        }
        return agileDataTag;
    }

    protected String getTitle(AgileReportShowTypeInfoDTO agileShowType, SnapDataDTO snapDataDTO, ApiMetadata apiMetadata, ThemeMapReport themeMapReport, ExecuteContext executeContext) {
        String title = null;
        if (AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
            title = agileShowType.getSectionName();
        }
        if (StringUtils.isEmpty(title)) {
            title = agileShowType.getTitle();
        }
        if (Strings.isEmpty((String)title)) {
            title = themeMapReport.getApiMetadata().getName();
        }
        if (StringUtils.isEmpty((String)title)) {
            return title;
        }
        Map recast = snapDataDTO.getBackRecast();
        if (MapUtils.isEmpty((Map)recast)) {
            return title;
        }
        String dateTitle = this.buildDateTitle(recast);
        title = dateTitle + title;
        String sortTitle = this.buildSortTitle(recast);
        title = title + sortTitle;
        return title;
    }

    private String buildSortTitle(Map<String, List<AgileKMConditionLimitRecast>> recast) {
        AgileKMConditionLimitStatistic statistic;
        List statistics;
        String sortTitle = "";
        String limitNum = "";
        AgileKMConditionLimitRecast limitRecast = null;
        AgileKMConditionLimitRecast sortRecast = null;
        for (List<AgileKMConditionLimitRecast> recastList : recast.values()) {
            Optional<AgileKMConditionLimitRecast> optSort;
            Optional<AgileKMConditionLimitRecast> optRecast = recastList.stream().filter(x -> StringUtils.equals((String)"limit", (String)x.getName())).findFirst();
            if (optRecast.isPresent()) {
                limitRecast = optRecast.get();
            }
            if (!(optSort = recastList.stream().filter(x -> StringUtils.equals((String)"sort", (String)x.getName())).findFirst()).isPresent()) continue;
            sortRecast = optSort.get();
        }
        if (limitRecast != null && !CollectionUtils.isEmpty((Collection)(statistics = limitRecast.getCondition().getStatistics()))) {
            statistic = (AgileKMConditionLimitStatistic)statistics.get(0);
            if (StringUtils.equals((String)"head", (String)statistic.getDirection())) {
                sortTitle = "TOP ";
            }
            if (StringUtils.equals((String)"tail", (String)statistic.getDirection())) {
                sortTitle = "DOWN ";
            }
            if (statistic.getStartPos() == null || Integer.valueOf(statistic.getStartPos()) < 1) {
                limitNum = limitNum + (Integer.valueOf(statistic.getEndPos()) + 1);
            }
        }
        if (sortRecast != null && !CollectionUtils.isEmpty((Collection)(statistics = sortRecast.getCondition().getStatistics()))) {
            statistic = (AgileKMConditionLimitStatistic)statistics.get(0);
            if (StringUtils.equals((String)"desc", (String)statistic.getType())) {
                sortTitle = "TOP ";
            }
            if (StringUtils.equals((String)"asc", (String)statistic.getType())) {
                sortTitle = "DOWN ";
            }
        }
        sortTitle = StringUtils.isEmpty((String)limitNum) ? "" : sortTitle + limitNum;
        return sortTitle;
    }

    private String buildDateTitle(Map<String, List<AgileKMConditionLimitRecast>> recast) {
        String dateTitle = "";
        AgileKMConditionLimitRecast titleRecast = null;
        for (List<AgileKMConditionLimitRecast> recastList : recast.values()) {
            Optional<AgileKMConditionLimitRecast> optRecast = recastList.stream().filter(x -> StringUtils.equals((String)"filter", (String)x.getName())).findFirst();
            if (!optRecast.isPresent()) continue;
            titleRecast = optRecast.get();
        }
        if (titleRecast != null) {
            AgileKMConditionLimitCondition agileKMConditionLimitCondition = titleRecast.getCondition();
            List items = agileKMConditionLimitCondition.getItems();
            String startTime = "";
            String endTime = "";
            String time = "";
            ArrayList lessOperator = Lists.newArrayList((Object[])new String[]{"lt", "le", "lte"});
            ArrayList greaterOperator = Lists.newArrayList((Object[])new String[]{"gt", "ge", "gte"});
            for (AgileKMConditionItem item : items) {
                if (!CollectionUtils.isEmpty((Collection)item.getItems())) {
                    if (!StringUtils.equals((String)"and", (String)item.getLogitype())) continue;
                    for (AgileKMConditionItem dateItem : item.getItems()) {
                        if (!DATE_FIELDS.contains(dateItem.getRight_value_type())) continue;
                        String right = dateItem.getRight().toString();
                        if (lessOperator.contains(dateItem.getOp())) {
                            String string = endTime = StringUtils.isEmpty((String)endTime) ? this.transData(right) : "";
                        }
                        if (!greaterOperator.contains(dateItem.getOp())) continue;
                        startTime = StringUtils.isEmpty((String)startTime) ? this.transData(right) : "";
                    }
                    continue;
                }
                String right = item.getRight().toString();
                if (DATE_FIELDS.contains(item.getRight_value_type()) && StringUtils.equals((String)"eq", (String)item.getOp())) {
                    String string = time = StringUtils.isEmpty((String)time) ? this.transData(right) : "";
                }
                if (DATE_FIELDS.contains(item.getRight_value_type()) && lessOperator.contains(item.getOp())) {
                    String string = endTime = StringUtils.isEmpty((String)endTime) ? this.transData(right) : "";
                }
                if (!DATE_FIELDS.contains(item.getRight_value_type()) || !greaterOperator.contains(item.getOp())) continue;
                startTime = StringUtils.isEmpty((String)startTime) ? this.transData(right) : "";
            }
            if (StringUtils.isNotEmpty((String)startTime) && StringUtils.isNotEmpty((String)endTime)) {
                dateTitle = startTime + "~" + endTime;
            } else if (StringUtils.isNotEmpty((String)time)) {
                dateTitle = time;
            }
        }
        return dateTitle;
    }

    private String transData(String date) {
        String formatDate = date;
        if (StringUtils.isNotEmpty((String)date)) {
            try {
                formatDate = TimeUtils.format((Date)TimeUtils.parseDate((String)date, (String)"yyyy-MM-dd"), (String)"yyyy.MM.dd");
            }
            catch (Exception e) {
                log.error("\u8bed\u4e49\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u539f\u65e5\u671f\u683c\u5f0f\uff1a{}" + date);
            }
        }
        return formatDate;
    }

    private AgileReportKMData getAgileReportKMData(SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        agileReportKMData.setShow(snapDataDTO.getShowDefine().getShow());
        agileReportKMData.setShowType(snapDataDTO.getShowDefine().getShowType());
        agileReportKMData.setActionId(snapDataDTO.getShowDefine().getShowType().stream().map(AgileReportShowTypeDTO::getActionId).collect(Collectors.joining(",")));
        return agileReportKMData;
    }

    private AgileReportKMData getAgileReportKMData(Map<String, Object> pageData) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        if (MapUtils.isNotEmpty(pageData)) {
            ArrayList actionIds = Lists.newArrayList();
            HashSet sceneCodes = Sets.newHashSet();
            pageData.forEach((x, y) -> {
                List actionList = (List)y;
                if (!CollectionUtils.isEmpty((Collection)actionList)) {
                    actionList.stream().forEach(actionMap -> {
                        if (actionMap.containsKey("actionId")) {
                            actionIds.add(MapUtils.getString((Map)actionMap, (Object)"actionId", (String)""));
                            sceneCodes.add(MapUtils.getString((Map)actionMap, (Object)"sceneCode", (String)""));
                        }
                    });
                }
            });
            if (!CollectionUtils.isEmpty((Collection)actionIds)) {
                List agileDataList = this.themeAgileDataService.querySceneMapsByActionId((List)actionIds);
                if (CollectionUtils.isEmpty((Collection)agileDataList)) {
                    return this.getAgileDataByCode((Set)sceneCodes);
                }
                if (!CollectionUtils.isEmpty((Collection)agileDataList)) {
                    agileReportKMData.setActionId(String.join((CharSequence)",", actionIds));
                    ArrayList agileReportShowList = Lists.newArrayList();
                    ArrayList agileReportShowTypeDTOList = Lists.newArrayList();
                    agileDataList.stream().forEach(agileData -> {
                        agileData.getShow().stream().forEach(show -> show.setActionId(agileData.getActionId()));
                        agileReportShowList.addAll(agileData.getShow());
                        agileData.getShowType().stream().forEach(showType -> showType.setActionId(agileData.getActionId()));
                        agileReportShowTypeDTOList.addAll(agileData.getShowType());
                    });
                    agileReportKMData.setShow((List)agileReportShowList);
                    agileReportKMData.setShowType((List)agileReportShowTypeDTOList);
                }
            }
        }
        return agileReportKMData;
    }

    private AgileReportKMData getAgileDataByCode(Set<String> codes) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        StringBuilder actionBuilder = new StringBuilder();
        ArrayList show = Lists.newArrayList();
        ArrayList showType = Lists.newArrayList();
        codes.stream().forEach(code -> {
            AgileReportKMData agileData = this.themeAgileDataService.querySceneMaps(code);
            if (agileData != null) {
                agileReportKMData.setScene(agileData.getScene());
                agileReportKMData.setCode(agileData.getCode());
                actionBuilder.append(agileData.getActionId()).append(",");
                agileReportKMData.setSceneTitle(agileData.getSceneTitle());
                agileReportKMData.setPageTurningFrequency(agileData.getPageTurningFrequency());
                agileReportKMData.setActionRelation(agileData.getActionRelation());
                if (!CollectionUtils.isEmpty((Collection)agileData.getShow())) {
                    show.addAll(agileData.getShow());
                }
                if (!CollectionUtils.isEmpty((Collection)agileData.getShowType())) {
                    showType.addAll(agileData.getShowType());
                }
            }
        });
        String actionId = actionBuilder.toString();
        if (!StringUtils.isEmpty((String)actionId)) {
            actionId = actionId.substring(0, actionId.length() - 1);
            agileReportKMData.setActionId(actionId);
            agileReportKMData.setShow((List)show);
            agileReportKMData.setShowType((List)showType);
        }
        return agileReportKMData;
    }
}

