/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.AgileDataAreaDefine;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportChartTypeEnum;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileDataBusinessEnum;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataTransDefineService;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgileDataTransDefineServiceImpl
implements AgileDataTransDefineService {
    private static final List<Integer> TRANS_ECHART_TYPES = Arrays.asList(3, 5);

    public void transEchartsDefine(AgileReportShowTypeInfoDTO showType, AgileReportShow show, SnapDataDTO snapDataDTO, ApiMetadata apiMetadata, String actionId, String target) {
        List measureFields;
        if (!"2".equals(snapDataDTO.getLink())) {
            return;
        }
        if (showType == null) {
            return;
        }
        if (TRANS_ECHART_TYPES.contains(showType.getValue()) && !CollectionUtils.isEmpty((Collection)(measureFields = ConvertGetAgileData.getStringField((String)"numeric", (String)target, (ApiMetadata)apiMetadata, (Boolean)true)))) {
            long businessSize = measureFields.stream().filter(field -> !StringUtils.isEmpty((Object)field.getBusinessType())).map(field -> field.getBusinessType()).distinct().count();
            if (businessSize == 2L) {
                this.transformationDualDefine(measureFields, show, showType);
            }
            if (businessSize > 2L) {
                showType.setValue(Integer.valueOf(0));
            }
        }
    }

    private void transformationDualDefine(List<MetadataField> measureFields, AgileReportShow show, AgileReportShowTypeInfoDTO showType) {
        Map<String, List<MetadataField>> amountFieldMap = measureFields.stream().collect(Collectors.groupingBy(field -> field.getBusinessType()));
        if (MapUtils.isEmpty(amountFieldMap)) {
            return;
        }
        String leftBusinessKey = amountFieldMap.keySet().stream().map(str -> new AbstractMap.SimpleEntry<String, Integer>((String)str, AgileDataBusinessEnum.getBusinessType((String)str))).filter(entry -> entry.getValue() != null).sorted(Map.Entry.comparingByValue()).findFirst().map(Map.Entry::getKey).orElse(null);
        ArrayList leftField = Lists.newArrayList();
        ArrayList rightField = Lists.newArrayList();
        amountFieldMap.forEach((key, value) -> {
            if (StringUtils.isEmpty((Object)leftBusinessKey)) {
                return;
            }
            if (key.equals(leftBusinessKey)) {
                this.getDualFields((List)amountFieldMap.get(key), "left", leftField, rightField);
            } else {
                this.getDualFields((List)amountFieldMap.get(key), "right", leftField, rightField);
            }
        });
        if (CollectionUtils.isEmpty((Collection)leftField) || CollectionUtils.isEmpty((Collection)rightField)) {
            return;
        }
        AgileReportRuleDTO agileReportRuleDTO = new AgileReportRuleDTO();
        agileReportRuleDTO.setType("doubleShaft");
        ArrayList rules = Lists.newArrayList();
        agileReportRuleDTO.setRules((List)rules);
        AgileDataAreaDefine leftAreaDefine = new AgileDataAreaDefine();
        leftAreaDefine.setApplyToFields((List)leftField);
        leftAreaDefine.setChart(AgileReportChartTypeEnum.getTypeByValue((Integer)showType.getValue()));
        AgileReportRuleInfoDTO leftAgileReportRuleInfo = new AgileReportRuleInfoDTO();
        leftAgileReportRuleInfo.setAreaDefine(Arrays.asList(leftAreaDefine));
        leftAgileReportRuleInfo.setDirection("left");
        rules.add(leftAgileReportRuleInfo);
        AgileDataAreaDefine rightAreaDefine = new AgileDataAreaDefine();
        rightAreaDefine.setApplyToFields((List)rightField);
        rightAreaDefine.setChart(AgileReportChartTypeEnum.getTypeByValue((Integer)showType.getValue()));
        AgileReportRuleInfoDTO rightAgileReportRuleInfo = new AgileReportRuleInfoDTO();
        rightAgileReportRuleInfo.setAreaDefine(Arrays.asList(rightAreaDefine));
        rightAgileReportRuleInfo.setDirection("left");
        rules.add(rightAgileReportRuleInfo);
        if (CollectionUtils.isEmpty((Collection)show.getAgileRule())) {
            show.setAgileRule(Arrays.asList(agileReportRuleDTO));
        } else {
            show.getAgileRule().add(agileReportRuleDTO);
        }
    }

    private void getDualFields(List<MetadataField> metadataFields, String mode, List<String> leftField, List<String> rightField) {
        if (!CollectionUtils.isEmpty(metadataFields)) {
            if ("left".equals(mode)) {
                leftField.addAll(metadataFields.stream().map(MetadataField::getName).collect(Collectors.toList()));
            } else {
                rightField.addAll(metadataFields.stream().map(MetadataField::getName).collect(Collectors.toList()));
            }
        }
    }
}

