/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.aspect;

import com.digiwin.athena.agiledataquery.annotation.RawResponse;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.model.DapResponse;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
public class ResponseWrapperAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWrapperAdvice.class);
    private static final String REQUEST_START_TIME = "REQUEST_START_TIME";
    private static final String IS_KG_ROUTED_REQUEST = "IS_KG_ROUTED_REQUEST";

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Class controllerClass = returnType.getContainingClass();
        if (returnType.hasMethodAnnotation(RawResponse.class) || controllerClass.isAnnotationPresent(RawResponse.class)) {
            return false;
        }
        if (DapResponse.class.isAssignableFrom(returnType.getParameterType())) {
            return false;
        }
        try {
            HttpServletRequest request;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && ResponseWrapperAdvice.isKgRoutedRequest((HttpServletRequest)(request = attributes.getRequest()))) {
                logger.debug("Skipping response wrapping for kg routed request");
                return false;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to check routing status", (Throwable)e);
        }
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof DapResponse) {
            return body;
        }
        long currentTime = System.currentTimeMillis();
        try {
            int duration = 0;
            try {
                HttpServletRequest httpRequest;
                Long startTime;
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null && (startTime = ResponseWrapperAdvice.getRequestStartTime((HttpServletRequest)(httpRequest = attributes.getRequest()))) != null) {
                    duration = (int)(currentTime - startTime);
                }
            }
            catch (Exception e) {
                logger.debug("Failed to calculate request duration", (Throwable)e);
            }
            String uuid = UUID.randomUUID().toString();
            DapResponse dapResponse = DapResponse.ok((Object)body);
            dapResponse.setDuration(Integer.valueOf(duration));
            dapResponse.setProfile((Object)DWServiceContext.getContext().getProfile());
            dapResponse.setUuid(uuid);
            logger.debug("Response wrapped: status={}, duration={}ms, uuid={}", new Object[]{dapResponse.getStatus(), duration, uuid});
            return dapResponse;
        }
        catch (Exception e) {
            logger.error("Failed to wrap response", (Throwable)e);
            DapResponse errorResponse = DapResponse.failed((String)("Response wrapping failed: " + e.getMessage()));
            errorResponse.setDuration(Integer.valueOf(0));
            errorResponse.setUuid(UUID.randomUUID().toString());
            return errorResponse;
        }
    }

    @ExceptionHandler(value={DWBusinessException.class})
    public ResponseEntity<DapResponse<Object>> handleDWBusinessException(DWBusinessException ex) {
        long currentTime = System.currentTimeMillis();
        int duration = 0;
        try {
            HttpServletRequest httpRequest;
            Long startTime;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && (startTime = ResponseWrapperAdvice.getRequestStartTime((HttpServletRequest)(httpRequest = attributes.getRequest()))) != null) {
                duration = (int)(currentTime - startTime);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to calculate request duration", (Throwable)e);
        }
        String uuid = UUID.randomUUID().toString();
        DapResponse dapResponse = DapResponse.builder().status(Integer.valueOf(400)).statusDescription("Bad Request").errorCode(ex.getErrorCode()).errorMessage(ex.getErrorMessage()).duration(Integer.valueOf(duration)).profile((Object)DWServiceContext.getContext().getProfile()).uuid(uuid).build();
        return new ResponseEntity((Object)dapResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<DapResponse<Object>> handleGenericException(Exception ex) {
        long currentTime = System.currentTimeMillis();
        int duration = 0;
        try {
            HttpServletRequest httpRequest;
            Long startTime;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null && (startTime = ResponseWrapperAdvice.getRequestStartTime((HttpServletRequest)(httpRequest = attributes.getRequest()))) != null) {
                duration = (int)(currentTime - startTime);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to calculate request duration", (Throwable)e);
        }
        if (ex instanceof ClassCastException) {
            logger.warn("Data type conversion error, likely due to KG service response format mismatch: {}", (Object)ex.getMessage());
            DapResponse dapResponse = DapResponse.builder().status(Integer.valueOf(500)).statusDescription("Data Format Error").errorCode("DATA_FORMAT_ERROR").errorMessage("\u6570\u636e\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff0c\u53ef\u80fd\u662fKG\u670d\u52a1\u8fd4\u56de\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u5339\u914d").duration(Integer.valueOf(duration)).profile((Object)DWServiceContext.getContext().getProfile()).uuid(UUID.randomUUID().toString()).build();
            return new ResponseEntity((Object)dapResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        String uuid = UUID.randomUUID().toString();
        DapResponse dapResponse = DapResponse.builder().status(Integer.valueOf(500)).statusDescription("Internal Server Error").errorCode("500").errorMessage(ex.getMessage()).duration(Integer.valueOf(duration)).profile((Object)DWServiceContext.getContext().getProfile()).uuid(uuid).build();
        return new ResponseEntity((Object)dapResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static Long getRequestStartTime(HttpServletRequest request) {
        Object startTime = request.getAttribute("REQUEST_START_TIME");
        return startTime instanceof Long ? (Long)startTime : null;
    }

    public static boolean isKgRoutedRequest(HttpServletRequest request) {
        Object isKgRouted = request.getAttribute("IS_KG_ROUTED_REQUEST");
        return Boolean.TRUE.equals(isKgRouted);
    }
}

