/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.cache;

import com.digiwin.athena.agiledataquery.cache.ICacheService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacheService
implements ICacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${scdispatcherUrl}")
    private String scdispatcherUrl;
    public static Map<String, String> compatibleKey = new HashMap();

    public Object deleteWithPattern(List<String> keyPattern) throws Exception {
        int count = 2000;
        Long delete = 0L;
        for (String pattern : keyPattern) {
            delete = delete + this.blurScanDelete(pattern, count);
        }
        this.deleteDataFootprintCache();
        return I18nUtils.getValue((String)"knowledgegraph.deleteNums") + delete;
    }

    private void deleteDataFootprintCache() throws DWBusinessException {
        try {
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("pattern", "datafootprint:v2");
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("token", AthenaUtils.getHeaderToken());
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(this.scdispatcherUrl + "/restful/service/DataFootprint/manual/deleteCache", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            if (result.getStatusCodeValue() != 200) {
                log.error("deleteDataFootprintCache failed");
            }
        }
        catch (Exception e) {
            log.error("deleteDataFootprintCache failed,{}", (Object)e.toString());
        }
    }

    public Long blurScanDelete(String matchKey, int count) {
        if (this.redisTemplate == null) {
            return 0L;
        }
        return (Long)this.redisTemplate.execute(connection -> {
            long keyCount = 0L;
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count((long)count).match(matchKey).build());){
                long cursorId = cursor.getCursorId();
                HashSet<String> keys = new HashSet<String>();
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                    if (cursorId != cursor.getCursorId()) {
                        keyCount += (long)keys.size();
                        this.deleteByKeys(keys);
                        keys = new HashSet();
                    }
                    cursorId = cursor.getCursorId();
                }
                if (cursor.getCursorId() == 0L || CollectionUtils.isNotEmpty(keys)) {
                    keyCount += (long)keys.size();
                    this.deleteByKeys(keys);
                }
            }
            catch (Exception e) {
                log.error("blurScanDelete failed,{}", (Object)e.toString());
            }
            return keyCount;
        });
    }

    private void deleteByKeys(Set<String> keys) {
        this.redisTemplate.delete(keys);
    }

    static {
        compatibleKey.put("kg", "knowledgegraph");
        compatibleKey.put("tag", "tagsystem");
        compatibleKey.put("presetLibrary", "presetlibrary");
    }
}

