/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GMCService {
    private static final Logger log = LoggerFactory.getLogger(GMCService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${gmcUrl}")
    private String gmcUrl;
    @Value(value="${iamApToken}")
    String appToken;

    public Object getCloudGood(String appId) {
        String requestUrl = this.gmcUrl + "/api/cloudgoods/" + appId;
        Object forObject = this.restTemplate.getForObject(requestUrl, Object.class, new Object[0]);
        return forObject;
    }

    public Object updateCloudGood(Object requestObj) throws DWBusinessException {
        String requestUrl = this.gmcUrl + "/api/cloudgoods/";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", this.getGmcToken());
        HttpEntity httpEntity = new HttpEntity(requestObj, (MultiValueMap)headers);
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, Object.class, new Object[0]);
        return stringResponseEntity.getBody();
    }

    public Object goodOff(String goodscode) throws DWBusinessException {
        return this.goodOnSale(goodscode, "0");
    }

    public Object goodOn(String goodscode) throws DWBusinessException {
        return this.goodOnSale(goodscode, "1");
    }

    public Object applyGoodOn(String goodscode) throws DWBusinessException {
        return this.goodOnSale(goodscode, "2");
    }

    public Object goodOnSale(String goodscode, String onsale) throws DWBusinessException {
        log.info("goodscode:{}, onsale:{}", (Object)goodscode, (Object)onsale);
        String requestUrl = this.gmcUrl + "/api/cloudgoods/{goodscode}/{onsale}";
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("goodscode", goodscode);
        varMap.put("onsale", onsale);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("digi-middleware-auth-user", this.getGmcToken());
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, Object.class, varMap);
        return stringResponseEntity.getBody();
    }

    public Object multiLanguage(Object requestObj) throws DWBusinessException {
        String requestUrl = this.gmcUrl + "/api/gmc/v2/multi/language";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", this.getGmcToken());
        HttpEntity httpEntity = new HttpEntity(requestObj, (MultiValueMap)headers);
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, Object.class, new Object[0]);
        return stringResponseEntity.getBody();
    }

    private String getGmcToken() throws DWBusinessException {
        String token;
        Map requestHeader = DWServiceContext.getContext().getRequestHeader();
        String string = token = requestHeader == null ? "" : (String)requestHeader.get("gmctoken");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.tokenMiss"));
        }
        return token;
    }

    public Object updateCloudGoodModules(Object requestObj) throws DWBusinessException {
        String requestUrl = this.gmcUrl + "/api/cloudgoods/modules";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-auth-user", this.getGmcToken());
        HttpEntity httpEntity = new HttpEntity(requestObj, (MultiValueMap)headers);
        ResponseEntity stringResponseEntity = this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, Object.class, new Object[0]);
        return stringResponseEntity.getBody();
    }
}

