/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.constant.Constants;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.domain.application.TenantApplication;
import com.digiwin.athena.agiledataquery.model.authority.AuthorizedUserResult;
import com.digiwin.athena.agiledataquery.model.authority.SimpleUser;
import com.digiwin.athena.agiledataquery.model.authority.app.AppDetailInfo;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import com.digiwin.athena.agiledataquery.utils.ThreadLocalCleanupUtil;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class IamService {
    private static final Logger log = LoggerFactory.getLogger(IamService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${iamUrl}")
    private String iamUrl;
    @Value(value="${aimUrl}")
    private String aimUrl;
    @Value(value="${iamTestUrl}")
    private String iamTestUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Value(value="${integrationPasswordHash}")
    private String integrationPasswordHash;
    @Value(value="${integrationInternalPasswordHash}")
    private String integrationInternalPasswordHash;
    private final String TENANT_APPLICATION = "/api/iam/v2/user/tenant/application";
    private final String SEND_MESSAGE = "/api/aim/v2/batch/user/message";
    private final String TENANT_ALL_APPLICATION = "/api/iam/v2/tenant/application";
    private final String LOGIN = "/api/iam/v2/identity/login/internal";
    private final String APP_INFO = "/api/iam/v2/app";
    private final String USER = "/api/iam/v2/user/simple";
    private final String POLICY_ACTION = "/api/iam/v2/policy/action";
    private final String USER_PERMISSION2 = "/api/iam/v2/permission/user";
    private final String USER_ROLE = "/api/iam/v2/user/role";
    private final String APP_ITEMS = "/api/iam/v2/app/action/ids";
    private final String USER_PERMISSION_TARGET_PREFIX = "drn:iam:app:";
    @Value(value="${iamApToken}")
    String appToken;

    public String getAthenaLicenceKey(String tenantId) throws Exception {
        return this.getLicenceKey("Athena", tenantId);
    }

    public String getAthenaLicenceKey() {
        return this.getLicenceKey("Athena");
    }

    public String getTenantType(String tenantId, Object loginResponse) throws Exception {
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)loginResponse));
        String enterpriseTenantType = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            enterpriseTenantType = loginJsonObject.getString("enterpriseTenantType");
        }
        return enterpriseTenantType;
    }

    public String getTenantToken(String tenantId, Object loginResponse) throws Exception {
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)loginResponse));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    public String getTenantToken(String tenantId) throws Exception {
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    private String getLicenceKey(String application, String tenantId) throws Exception {
        List tenantApplications;
        Optional<TenantApplication> any;
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        if ((any = (tenantApplications = this.listApplications(token)).stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)application)).findAny()).isPresent()) {
            return any.get().getSecretKey();
        }
        log.info("getLicenceKey not found application:{} of tenantId:{}", (Object)application, (Object)tenantId);
        return null;
    }

    private String getLicenceKey(String application) {
        List tenantApplications = this.listApplications();
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)application)).findAny();
        if (any.isPresent()) {
            return any.get().getSecretKey();
        }
        return null;
    }

    private List<TenantApplication> listApplications() {
        String token = DWServiceContext.getContext().getToken();
        return this.listApplications(token);
    }

    private List<TenantApplication> listApplications(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/user/tenant/application", HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List tenantApplications = JSONObject.parseArray((String)JSON.toJSONString((Object)body), TenantApplication.class);
        return tenantApplications;
    }

    public Object login(String tenantId) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", this.integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/identity/login/internal", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public AppDetailInfo appDetailInfo(String appCode, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("id", appCode);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/app", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        AppDetailInfo tenantApplications = (AppDetailInfo)JSONObject.parseObject((String)JSON.toJSONString((Object)body), AppDetailInfo.class);
        return tenantApplications;
    }

    public List<SimpleUser> getUser(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/user/simple", HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List simpleUsers = JSONObject.parseArray((String)JSON.toJSONString((Object)body), SimpleUser.class);
        return simpleUsers;
    }

    public List<AuthorizedUserResult> getAuthorizedUser(String token, String appCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/query/" + appCode + "/authorized/user", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        List authorizedUserResultList = JSONObject.parseArray((String)JSON.toJSONString((Object)body), AuthorizedUserResult.class);
        return authorizedUserResultList;
    }

    public Object policyAction(String type, Long targetSid, Long sysSid, boolean effect, Long actionSid, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("type", type);
        requestMap.put("targetSid", targetSid);
        requestMap.put("sysSid", sysSid);
        requestMap.put("effect", effect);
        requestMap.put("actionSid", actionSid);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/policy/action", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public Object getUserPermission(String appCode, String userId, String token) {
        if (appCode == null || StringUtils.isEmpty((CharSequence)userId) || StringUtils.isEmpty((CharSequence)token)) {
            throw new RuntimeException(I18nUtils.getValue((String)"knowledgegraph.tokenOrUserMiss"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", userId);
        requestMap.put("sysId", appCode);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/permission/user", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public Object listAllTenantApplications(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/tenant/application", HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public Object userRole(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("id", userId);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/user/role", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }

    public List<String> appItems(List<String> appIds) {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, List<String>> requestMap = new HashMap<String, List<String>>();
        requestMap.put("appIds", appIds);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/app/action/ids", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        Map body = (Map)resEntity.getBody();
        log.info("appItems response:{}", (Object)body);
        return (List)body.get("data");
    }

    public boolean isSuperAdmin(String userId, String token) {
        JSONArray roles;
        log.info("isSuperAdmin userId:{}", (Object)userId);
        Object userRoleRes = this.userRole(userId, token);
        log.info("userRoleResult result:{}", userRoleRes);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)userRoleRes));
        if (jsonObject != null && (roles = jsonObject.getJSONArray("roles")) != null && roles.size() > 0) {
            for (int i = 0; i < roles.size(); ++i) {
                JSONObject rolesJSONObject = roles.getJSONObject(i);
                String id = rolesJSONObject.getString("id");
                if (!StringUtils.equals((CharSequence)id, (CharSequence)"superadmin")) continue;
                return true;
            }
        }
        return false;
    }

    public Object startEnterpriseOperation(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap requestMap = new HashMap();
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/app/initialize", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("startEnterpriseOperation response:{}", body);
        return body;
    }

    public String getIntegrationToken(String tenantId, String appToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", appToken);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", this.integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = this.iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            JSONObject body = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
            return body.getString("token");
        }
        catch (Exception e) {
            log.info("getUserToken by integration have exception\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public String getTestIntegrationToken(String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", this.integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = this.iamTestUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        try {
            ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            JSONObject body = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
            return body.getString("token");
        }
        catch (Exception e) {
            log.info("getUserToken by integration have exception\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public void dispatcherMessage(String token, List<String> userIdList, String message, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        ArrayList list = new ArrayList();
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        LinkedTreeMap messageMap = new LinkedTreeMap();
        messageMap.put((Object)"type", (Object)"activity");
        messageMap.put((Object)"category", (Object)"notice");
        messageMap.put((Object)"hasReadDetail", (Object)Boolean.FALSE);
        LinkedTreeMap treeMap = new LinkedTreeMap();
        treeMap.put((Object)"msg", (Object)message);
        messageMap.put((Object)"content", (Object)treeMap);
        requestMap.put("message", messageMap);
        requestMap.put("tenantId", tenantId);
        requestMap.put("userIdList", userIdList);
        list.add(requestMap);
        HttpEntity arrayListHttpEntity = new HttpEntity(list, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.aimUrl + "/api/aim/v2/batch/user/message", HttpMethod.POST, arrayListHttpEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        log.info("dispatcherMessage response:{}", body);
    }

    public Map<String, Object> batchQueryUserAppPermission(List<String> appCodes, String userId) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }
        DWServiceContext.ContextData context = DWServiceContext.getContext();
        String token = AthenaUtils.getHeaderToken();
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(appCodes.size());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        long startTime = System.currentTimeMillis();
        try {
            CompletableFuture[] futures = (CompletableFuture[])appCodes.stream().map(code -> CompletableFuture.runAsync(() -> {
                DWServiceContext.setContext((DWServiceContext.ContextData)context);
                try {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    Object o = this.getUserPermission(code, userId, token);
                    if (!ObjectUtils.isEmpty((Object)o)) {
                        result.put((String)code, o);
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u7528\u6237\u6743\u9650\u5931\u8d25\uff0cappCode: {}, userId: {}, error: {}", new Object[]{code, userId, e.getMessage()});
                }
                finally {
                    ThreadLocalCleanupUtil.cleanupAllThreadLocals();
                    RequestContextHolder.resetRequestAttributes();
                }
            }, Constants.APP_EXECUTE_POOL)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u6743\u9650\u8d85\u65f6\uff0c\u8017\u65f6: {}ms, userId: {}, appCodes: {}", new Object[]{elapsedTime, userId, appCodes});
        }
        catch (InterruptedException e) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u6743\u9650\u88ab\u4e2d\u65ad\uff0c\u8017\u65f6: {}ms, userId: {}, appCodes: {}", new Object[]{elapsedTime, userId, appCodes});
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u6743\u9650\u6267\u884c\u5f02\u5e38\uff0c\u8017\u65f6: {}ms, userId: {}, appCodes: {}, error: {}", new Object[]{elapsedTime, userId, appCodes, e.getMessage()});
        }
        catch (Exception e) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u6743\u9650\u5f02\u5e38\uff0c\u8017\u65f6: {}ms, userId: {}, appCodes: {}, error: {}", new Object[]{elapsedTime, userId, appCodes, e.getMessage()});
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u6743\u9650\u5b8c\u6210\uff0c\u8017\u65f6: {}ms, userId: {}, \u5e94\u7528\u6570\u91cf: {}, \u6210\u529f\u6570\u91cf: {}", new Object[]{elapsedTime, userId, appCodes.size(), result.size()});
        return result;
    }

    public String getTenantName(String tenantId) throws Exception {
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String tenantName = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            tenantName = loginJsonObject.getString("tenantName");
        }
        return tenantName;
    }

    public Object getUserPermissionByKey2(String key) {
        log.info("key:{}", (Object)key);
        String appCode = key.substring(0, key.indexOf(":"));
        String module = key.substring(0, key.lastIndexOf(":"));
        String functionKey = key.substring(key.lastIndexOf(":") + 1);
        Object allUserPermission = this.getUserPermission(appCode);
        JSONObject responseJson = JSONObject.parseObject((String)JSON.toJSONString((Object)allUserPermission));
        String code = responseJson.getString("code");
        if (!"200".equals(code)) {
            return "";
        }
        JSONArray permissions = responseJson.getJSONArray("data");
        if (permissions == null) {
            return "allow";
        }
        for (int i = 0; i < permissions.size(); ++i) {
            JSONObject permissionJson = permissions.getJSONObject(i);
            JSONObject conditions = permissionJson.getJSONObject("conditions");
            String target = permissionJson.getString("target");
            if (!StringUtils.equals((CharSequence)target, (CharSequence)("drn:iam:app:" + module))) continue;
            String parentTarget = target.substring(0, target.lastIndexOf(":")) + ":module-enable";
            String parentPermission = this.chargeParent(permissions, parentTarget);
            if (!StringUtils.equals((CharSequence)parentPermission, (CharSequence)"allow")) {
                log.info("parentModule\uff1a{} not allow", (Object)parentTarget);
                return parentPermission;
            }
            String effect = permissionJson.getString("effect");
            if (!StringUtils.equals((CharSequence)"allow", (CharSequence)effect)) {
                return "";
            }
            JSONObject moduleJsonObject = conditions.getJSONObject("drn:iam:app:" + module);
            if (moduleJsonObject == null) continue;
            String psermissionResult = moduleJsonObject.getString(functionKey);
            return psermissionResult;
        }
        return "allow";
    }

    private String chargeParent(JSONArray permissions, String parentTarget) {
        for (int i = 0; i < permissions.size(); ++i) {
            JSONObject permissionJson = permissions.getJSONObject(i);
            JSONObject conditions = permissionJson.getJSONObject("conditions");
            String target = permissionJson.getString("target");
            if (!StringUtils.equals((CharSequence)target, (CharSequence)parentTarget)) continue;
            String effect = permissionJson.getString("effect");
            if (!StringUtils.equals((CharSequence)"allow", (CharSequence)effect)) {
                return "";
            }
            JSONObject moduleJsonObject = conditions.getJSONObject(parentTarget);
            if (moduleJsonObject == null) continue;
            String psermissionResult = moduleJsonObject.getString("enable");
            return psermissionResult;
        }
        return "allow";
    }

    public Object getUserPermission(String appCode) {
        AthenaUser user = AthenaUserLocal.getUser();
        if (user == null || StringUtils.isEmpty((CharSequence)user.getToken()) || StringUtils.isEmpty((CharSequence)user.getUserId())) {
            throw new DWBusinessException("\u83b7\u53d6\u7528\u6237\u6388\u6743\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("digi-middleware-auth-app", this.appToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("userId", user.getUserId());
        requestMap.put("sysId", appCode);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/permission/user", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }
}

