/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class KgService {
    private static final Logger log = LoggerFactory.getLogger(KgService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${routing.kg.url:https://knowledgemaps-test.apps.digiwincloud.com.cn}")
    private String kgServiceUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Value(value="${deploy.cloud:''}")
    private String deployCloud;

    public Object doForwardToKg(Map<String, Object> requestBody) {
        Object result = null;
        if (!Objects.equals(this.deployCloud, "cloud")) {
            return result;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return result;
        }
        try {
            HttpServletRequest request = attributes.getRequest();
            Object data = this.forwardToKG(request, requestBody);
            if (data instanceof Map) {
                Map mapData = (Map)data;
                result = mapData.get("response");
            } else if (data instanceof JSONObject) {
                JSONObject jsonObjectData = (JSONObject)data;
                result = jsonObjectData.get((Object)"response");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Object doForwardToKg(String url, HttpMethod method, Map<String, Object> requestMap) {
        Object result = null;
        if (!Objects.equals(this.deployCloud, "cloud")) {
            return result;
        }
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders((HttpHeaders)headers);
        String baseUrl = this.buildKGUrl(this.kgServiceUrl + url, requestMap, method);
        try {
            ResponseEntity response = this.sendRequestToKG(baseUrl, method, requestMap, headers);
            Object data = response.getBody();
            if (data instanceof Map) {
                Map mapData = (Map)data;
                result = mapData.get("response");
            } else if (data instanceof JSONObject) {
                JSONObject jsonObjectData = (JSONObject)data;
                result = jsonObjectData.get((Object)"response");
            }
        }
        catch (Exception e) {
            log.error("KG\u670d\u52a1\u8c03\u7528\u5931\u8d25: " + e.getMessage());
        }
        return result;
    }

    public Object forwardToKG(HttpServletRequest request, Map<String, Object> requestBody) {
        try {
            String httpMethod = request.getMethod().toUpperCase();
            HttpMethod method = HttpMethod.valueOf((String)httpMethod);
            String fullKGUrl = this.buildKGUrl(this.kgServiceUrl + request.getRequestURI(), requestBody, method);
            HttpHeaders headers = this.buildForwardHeaders(request);
            ResponseEntity response = this.sendRequestToKG(fullKGUrl, method, requestBody, headers);
            this.logRouting(request.getRequestURI(), "KG", String.format("\u8f6c\u53d1\u6210\u529f (%s)", httpMethod), fullKGUrl);
            return response.getBody();
        }
        catch (Exception e) {
            this.logRouting(request.getRequestURI(), "KG", "\u8f6c\u53d1\u62a5\u9519: " + e.getMessage(), this.kgServiceUrl);
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("status", "error");
            error.put("message", "KG\u670d\u52a1\u4e0d\u53ef\u7528: " + e.getMessage());
            error.put("service", "kg");
            error.put("httpMethod", request.getMethod());
            error.put("timestamp", System.currentTimeMillis());
            return error;
        }
    }

    private HttpHeaders buildForwardHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders((HttpHeaders)headers);
        return headers;
    }

    private String buildKGUrl(String baseUrl, Map<String, Object> requestBody, HttpMethod method) {
        if (HttpMethod.GET.equals((Object)method) && !requestBody.isEmpty()) {
            StringBuilder queryParams = new StringBuilder();
            for (Map.Entry<String, Object> entry : requestBody.entrySet()) {
                if (queryParams.length() > 0) {
                    queryParams.append("&");
                }
                queryParams.append(entry.getKey()).append("=").append(entry.getValue());
            }
            if (queryParams.length() > 0) {
                baseUrl = baseUrl + "?" + queryParams;
            }
        }
        return baseUrl;
    }

    private ResponseEntity<Object> sendRequestToKG(String url, HttpMethod method, Map<String, Object> requestBody, HttpHeaders headers) {
        HttpEntity entity;
        switch (1.$SwitchMap$org$springframework$http$HttpMethod[method.ordinal()]) {
            case 1: 
            case 2: {
                entity = new HttpEntity((MultiValueMap)headers);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                entity = new HttpEntity(requestBody, (MultiValueMap)headers);
                break;
            }
            default: {
                entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            }
        }
        return this.restTemplate.exchange(url, method, entity, Object.class, new Object[0]);
    }

    private void logRouting(String originalPath, String target, String result, String targetUrl) {
        String logMessage = String.format("[SmartRouting] %s -> %s: %s", originalPath, target, result);
        if (targetUrl != null && !targetUrl.isEmpty()) {
            logMessage = logMessage + " (URL: " + targetUrl + ")";
        }
        log.info(logMessage);
    }
}

