/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.clients;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.po.DapResponse;
import com.digiwin.athena.agiledataquery.po.TbbGlobal;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TBBUtils {
    private static final Logger log = LoggerFactory.getLogger(TBBUtils.class);
    private final String GLOBAL_DASH_INFO = "/tbb-system/platform_integration/global_dash_info";
    @Value(value="${tbbUrl}")
    private String tbbUrl;
    @Autowired
    RestTemplate restTemplate;

    public List<TbbGlobal> getGlobal() throws DWBusinessException {
        String url = this.tbbUrl + "/tbb-system/platform_integration/global_dash_info";
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, entity, DapResponse.class, new Object[0]);
        try {
            log.info("getGlobal tbbRes:{}", result.getBody());
            Map response = (Map)((DapResponse)result.getBody()).getResponse();
            Object data = response.get("data");
            return JSON.parseArray((String)JSON.toJSONString(data), TbbGlobal.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.getGlobalError"));
        }
    }
}

