/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.config;

import com.digiwin.athena.agiledataquery.aspect.NullToDapResponseReturnValueHandler;
import com.digiwin.athena.agiledataquery.config.InterceptorConfig;
import com.digiwin.athena.agiledataquery.interceptor.UserLoginInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    @Autowired
    private UserLoginInterceptor userLoginInterceptor;
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    @Autowired
    private InterceptorConfig interceptorConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("=== \u5f00\u59cb\u6ce8\u518c\u62e6\u622a\u5668 ===");
        log.info("\u62e6\u622a\u5668\u7c7b\u578b: UserLoginInterceptor");
        List<String> excludePaths = this.interceptorConfig.getFinalExcludePaths();
        if (excludePaths != null && !excludePaths.isEmpty()) {
            log.info("\u4ece\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5230 {} \u4e2a\u6392\u9664\u8def\u5f84:", (Object)excludePaths.size());
            excludePaths.forEach(path -> log.info("  - {}", path));
        } else {
            log.warn("\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u627e\u5230\u62e6\u622a\u5668\u6392\u9664\u8def\u5f84\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e");
            excludePaths = Arrays.asList("/swagger**/**", "/webjars/**", "/v3/**", "/doc.html", "/actuator/**");
        }
        registry.addInterceptor((HandlerInterceptor)this.userLoginInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePaths.toArray(new String[0]));
        log.info("\u62e6\u622a\u5668\u6ce8\u518c\u5b8c\u6210\uff0c\u6392\u9664\u8def\u5f84\u6570\u91cf: {}", (Object)excludePaths.size());
        log.info("=== \u62e6\u622a\u5668\u6ce8\u518c\u5b8c\u6210 ===");
    }

    @PostConstruct
    public void initReturnValueHandlers() {
        List handlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        String TARGET_PROCESSOR = "RequestResponseBodyMethodProcessor";
        ArrayList<NullToDapResponseReturnValueHandler> newHandlers = new ArrayList<NullToDapResponseReturnValueHandler>(handlers);
        for (int i = 0; i < newHandlers.size(); ++i) {
            HandlerMethodReturnValueHandler handler = (HandlerMethodReturnValueHandler)newHandlers.get(i);
            String className = handler.getClass().getSimpleName();
            if (!"RequestResponseBodyMethodProcessor".equals(className)) continue;
            NullToDapResponseReturnValueHandler nullHandler = new NullToDapResponseReturnValueHandler(handler);
            newHandlers.set(i, nullHandler);
            this.requestMappingHandlerAdapter.setReturnValueHandlers(newHandlers);
            break;
        }
    }
}

